@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes how data from an input is serialized or how data is serialized when written to an output in CSV format.
 * @property encoding Specifies the encoding of the incoming data in the case of input and the encoding of outgoing data in the case of output. Required on PUT (CreateOrReplace) requests.
 * @property fieldDelimiter Specifies the delimiter that will be used to separate comma-separated value (CSV) records. See https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-input or https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for a list of supported values. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of serialization that the input or output uses. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Csv'.
 */
public data class CsvSerializationResponse(
    public val encoding: String? = null,
    public val fieldDelimiter: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.CsvSerializationResponse): CsvSerializationResponse = CsvSerializationResponse(
            encoding = javaType.encoding().map({ args0 -> args0 }).orElse(null),
            fieldDelimiter = javaType.fieldDelimiter().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
