@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
 * @property conditions A collection of zero or more conditions applicable to the resource, or to the job overall, that warrant customer attention.
 */
public data class DiagnosticsResponse(
    public val conditions: List<DiagnosticConditionResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.DiagnosticsResponse): DiagnosticsResponse = DiagnosticsResponse(
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.DiagnosticConditionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
