@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a DocumentDB output data source.
 * @property accountId The DocumentDB account name or ID. Required on PUT (CreateOrReplace) requests.
 * @property accountKey The account key for the DocumentDB account. Required on PUT (CreateOrReplace) requests.
 * @property collectionNamePattern The collection name pattern for the collections to be used. The collection name format can be constructed using the optional {partition} token, where partitions start from 0. See the DocumentDB section of https://docs.microsoft.com/en-us/rest/api/streamanalytics/stream-analytics-output for more information. Required on PUT (CreateOrReplace) requests.
 * @property database The name of the DocumentDB database. Required on PUT (CreateOrReplace) requests.
 * @property documentId The name of the field in output events used to specify the primary key which insert or update operations are based on.
 * @property partitionKey The name of the field in output events used to specify the key for partitioning output across collections. If 'collectionNamePattern' contains the {partition} token, this property is required to be specified.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Storage/DocumentDB'.
 */
public data class DocumentDbOutputDataSourceResponse(
    public val accountId: String? = null,
    public val accountKey: String? = null,
    public val collectionNamePattern: String? = null,
    public val database: String? = null,
    public val documentId: String? = null,
    public val partitionKey: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.DocumentDbOutputDataSourceResponse): DocumentDbOutputDataSourceResponse = DocumentDbOutputDataSourceResponse(
            accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
            accountKey = javaType.accountKey().map({ args0 -> args0 }).orElse(null),
            collectionNamePattern = javaType.collectionNamePattern().map({ args0 -> args0 }).orElse(null),
            database = javaType.database().map({ args0 -> args0 }).orElse(null),
            documentId = javaType.documentId().map({ args0 -> args0 }).orElse(null),
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
