@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an Event Hub input data source that contains stream data.
 * @property authenticationMode Authentication Mode.
 * @property consumerGroupName The name of an Event Hub Consumer Group that should be used to read events from the Event Hub. Specifying distinct consumer group names for multiple inputs allows each of those inputs to receive the same events from the Event Hub. If not specified, the input uses the Event Hub’s default consumer group.
 * @property eventHubName The name of the Event Hub. Required on PUT (CreateOrReplace) requests.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/EventHub'.
 */
public data class EventHubStreamInputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val consumerGroupName: String? = null,
    public val eventHubName: String? = null,
    public val serviceBusNamespace: String? = null,
    public val sharedAccessPolicyKey: String? = null,
    public val sharedAccessPolicyName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.EventHubStreamInputDataSourceResponse): EventHubStreamInputDataSourceResponse = EventHubStreamInputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            consumerGroupName = javaType.consumerGroupName().map({ args0 -> args0 }).orElse(null),
            eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
            serviceBusNamespace = javaType.serviceBusNamespace().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyKey = javaType.sharedAccessPolicyKey().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyName = javaType.sharedAccessPolicyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
