@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a file input data source that contains reference data.
 * @property path The path of the file.
 * @property type Indicates the type of input data source containing reference data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'File'.
 */
public data class FileReferenceInputDataSourceResponse(
    public val path: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.FileReferenceInputDataSourceResponse): FileReferenceInputDataSourceResponse = FileReferenceInputDataSourceResponse(
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
