@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the output of a function.
 * @property dataType The (Azure Stream Analytics supported) data type of the function output. A list of valid Azure Stream Analytics data types are described at https://msdn.microsoft.com/en-us/library/azure/dn835065.aspx
 */
public data class FunctionOutputResponse(
    public val dataType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.FunctionOutputResponse): FunctionOutputResponse = FunctionOutputResponse(
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
