@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a blob input data source that contains stream data.
 * @property topic The name of the Service Bus topic.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'GatewayMessageBus'.
 */
public data class GatewayMessageBusStreamInputDataSourceResponse(
    public val topic: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.GatewayMessageBusStreamInputDataSourceResponse): GatewayMessageBusStreamInputDataSourceResponse =
            GatewayMessageBusStreamInputDataSourceResponse(
                topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
