@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Stream Analytics Cluster object
 * @property capacityAllocated Represents the number of streaming units currently being used on the cluster.
 * @property capacityAssigned Represents the sum of the SUs of all streaming jobs associated with the cluster. If all of the jobs were running, this would be the capacity allocated.
 * @property clusterId Unique identifier for the cluster.
 * @property createdDate The date this cluster was created.
 * @property etag The current entity tag for the cluster. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The status of the cluster provisioning. The three terminal states are: Succeeded, Failed and Canceled
 * @property sku The SKU of the cluster. This determines the size/capacity of the cluster. Required on PUT (CreateOrUpdate) requests.
 * @property tags Resource tags.
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetClusterResult(
    public val capacityAllocated: Int,
    public val capacityAssigned: Int,
    public val clusterId: String,
    public val createdDate: String,
    public val etag: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val sku: ClusterSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.GetClusterResult): GetClusterResult = GetClusterResult(
            capacityAllocated = javaType.capacityAllocated(),
            capacityAssigned = javaType.capacityAssigned(),
            clusterId = javaType.clusterId(),
            createdDate = javaType.createdDate(),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.ClusterSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
