@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Complete information about the private endpoint.
 * @property createdDate The date when this private endpoint was created.
 * @property etag Unique opaque string (generally a GUID) that represents the metadata state of the resource (private endpoint) and changes whenever the resource is updated. Required on PUT (CreateOrUpdate) requests.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property manualPrivateLinkServiceConnections A list of connections to the remote resource. Immutable after it is set.
 * @property name The name of the resource
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetPrivateEndpointResult(
    public val createdDate: String,
    public val etag: String,
    public val id: String,
    public val manualPrivateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? =
        null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.GetPrivateEndpointResult): GetPrivateEndpointResult = GetPrivateEndpointResult(
            createdDate = javaType.createdDate(),
            etag = javaType.etag(),
            id = javaType.id(),
            manualPrivateLinkServiceConnections = javaType.manualPrivateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
