@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes an IoT Hub input data source that contains stream data.
 * @property consumerGroupName The name of an IoT Hub Consumer Group that should be used to read events from the IoT Hub. If not specified, the input uses the Iot Hub’s default consumer group.
 * @property endpoint The IoT Hub endpoint to connect to (ie. messages/events, messages/operationsMonitoringEvents, etc.).
 * @property iotHubNamespace The name or the URI of the IoT Hub. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the IoT Hub. This policy must contain at least the Service connect permission. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of input data source containing stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.Devices/IotHubs'.
 */
public data class IoTHubStreamInputDataSourceResponse(
    public val consumerGroupName: String? = null,
    public val endpoint: String? = null,
    public val iotHubNamespace: String? = null,
    public val sharedAccessPolicyKey: String? = null,
    public val sharedAccessPolicyName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.IoTHubStreamInputDataSourceResponse): IoTHubStreamInputDataSourceResponse = IoTHubStreamInputDataSourceResponse(
            consumerGroupName = javaType.consumerGroupName().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            iotHubNamespace = javaType.iotHubNamespace().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyKey = javaType.sharedAccessPolicyKey().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyName = javaType.sharedAccessPolicyName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
