@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of streaming jobs. Populated by a List operation.
 * @property nextLink The URL to fetch the next set of streaming jobs.
 * @property value A list of streaming jobs.
 */
public data class ListClusterStreamingJobsResult(
    public val nextLink: String,
    public val `value`: List<ClusterJobResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.ListClusterStreamingJobsResult): ListClusterStreamingJobsResult = ListClusterStreamingJobsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.ClusterJobResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
