@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An output object, containing all information associated with the named output. All outputs are contained under a streaming job.
 * @property datasource Describes the data source that output will be written to. Required on PUT (CreateOrReplace) requests.
 * @property diagnostics Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
 * @property etag The current entity tag for the output. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property id Resource Id
 * @property name Resource name
 * @property serialization Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
 * @property sizeWindow The size window to constrain a Stream Analytics output to.
 * @property timeWindow The time frame for filtering Stream Analytics job outputs.
 * @property type Resource type
 */
public data class OutputResponse(
    public val datasource: Any? = null,
    public val diagnostics: DiagnosticsResponse,
    public val etag: String,
    public val id: String,
    public val name: String? = null,
    public val serialization: Any? = null,
    public val sizeWindow: Int? = null,
    public val timeWindow: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.OutputResponse): OutputResponse = OutputResponse(
            datasource = javaType.datasource().map({ args0 -> args0 }).orElse(null),
            diagnostics = javaType.diagnostics().let({ args0 ->
                com.pulumi.azurenative.streamanalytics.kotlin.outputs.DiagnosticsResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            serialization = javaType.serialization().map({ args0 -> args0 }).orElse(null),
            sizeWindow = javaType.sizeWindow().map({ args0 -> args0 }).orElse(null),
            timeWindow = javaType.timeWindow().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
