@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The properties that are associated with an input containing reference data.
 * @property compression Describes how input data is compressed
 * @property datasource Describes an input data source that contains reference data. Required on PUT (CreateOrReplace) requests.
 * @property diagnostics Describes conditions applicable to the Input, Output, or the job overall, that warrant customer attention.
 * @property etag The current entity tag for the input. This is an opaque string. You can use it to detect whether the resource has changed between requests. You can also use it in the If-Match or If-None-Match headers for write operations for optimistic concurrency.
 * @property partitionKey partitionKey Describes a key in the input data which is used for partitioning the input data
 * @property serialization Describes how data from an input is serialized or how data is serialized when written to an output. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates whether the input is a source of reference data or stream data. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Reference'.
 */
public data class ReferenceInputPropertiesResponse(
    public val compression: CompressionResponse? = null,
    public val datasource: Any? = null,
    public val diagnostics: DiagnosticsResponse,
    public val etag: String,
    public val partitionKey: String? = null,
    public val serialization: Any? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.ReferenceInputPropertiesResponse): ReferenceInputPropertiesResponse = ReferenceInputPropertiesResponse(
            compression = javaType.compression().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.streamanalytics.kotlin.outputs.CompressionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            datasource = javaType.datasource().map({ args0 -> args0 }).orElse(null),
            diagnostics = javaType.diagnostics().let({ args0 ->
                com.pulumi.azurenative.streamanalytics.kotlin.outputs.DiagnosticsResponse.Companion.toKotlin(args0)
            }),
            etag = javaType.etag(),
            partitionKey = javaType.partitionKey().map({ args0 -> args0 }).orElse(null),
            serialization = javaType.serialization().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
