@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a Service Bus Topic output data source.
 * @property authenticationMode Authentication Mode.
 * @property propertyColumns A string array of the names of output columns to be attached to Service Bus messages as custom properties.
 * @property serviceBusNamespace The namespace that is associated with the desired Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyKey The shared access policy key for the specified shared access policy. Required on PUT (CreateOrReplace) requests.
 * @property sharedAccessPolicyName The shared access policy name for the Event Hub, Service Bus Queue, Service Bus Topic, etc. Required on PUT (CreateOrReplace) requests.
 * @property systemPropertyColumns The system properties associated with the Service Bus Topic Output. The following system properties are supported: ReplyToSessionId, ContentType, To, Subject, CorrelationId, TimeToLive, PartitionKey, SessionId, ScheduledEnqueueTime, MessageId, ReplyTo, Label, ScheduledEnqueueTimeUtc.
 * @property topicName The name of the Service Bus Topic. Required on PUT (CreateOrReplace) requests.
 * @property type Indicates the type of data source output will be written to. Required on PUT (CreateOrReplace) requests.
 * Expected value is 'Microsoft.ServiceBus/Topic'.
 */
public data class ServiceBusTopicOutputDataSourceResponse(
    public val authenticationMode: String? = null,
    public val propertyColumns: List<String>? = null,
    public val serviceBusNamespace: String? = null,
    public val sharedAccessPolicyKey: String? = null,
    public val sharedAccessPolicyName: String? = null,
    public val systemPropertyColumns: Map<String, String>? = null,
    public val topicName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.ServiceBusTopicOutputDataSourceResponse): ServiceBusTopicOutputDataSourceResponse = ServiceBusTopicOutputDataSourceResponse(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            propertyColumns = javaType.propertyColumns().map({ args0 -> args0 }),
            serviceBusNamespace = javaType.serviceBusNamespace().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyKey = javaType.sharedAccessPolicyKey().map({ args0 -> args0 }).orElse(null),
            sharedAccessPolicyName = javaType.sharedAccessPolicyName().map({ args0 -> args0 }).orElse(null),
            systemPropertyColumns = javaType.systemPropertyColumns().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            topicName = javaType.topicName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
