@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.streamanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties that are associated with a SKU.
 * @property name The name of the SKU. Required on PUT (CreateOrReplace) requests.
 */
public data class SkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.streamanalytics.outputs.SkuResponse): SkuResponse = SkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
