@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin

import com.pulumi.azurenative.subscription.kotlin.outputs.SubscriptionAliasResponsePropertiesResponse
import com.pulumi.azurenative.subscription.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.subscription.kotlin.outputs.SubscriptionAliasResponsePropertiesResponse.Companion.toKotlin as subscriptionAliasResponsePropertiesResponseToKotlin
import com.pulumi.azurenative.subscription.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Alias].
 */
@PulumiTagMarker
public class AliasResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AliasArgs = AliasArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AliasArgsBuilder.() -> Unit) {
        val builder = AliasArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alias {
        val builtJavaResource = com.pulumi.azurenative.subscription.Alias(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alias(builtJavaResource)
    }
}

/**
 * Subscription Information with the alias.
 * Azure REST API version: 2021-10-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01.
 * ## Example Usage
 * ### CreateAlias
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @alias = new AzureNative.Subscription.Alias("alias", new()
 *     {
 *         AliasName = "aliasForNewSub",
 *         Properties = new AzureNative.Subscription.Inputs.PutAliasRequestPropertiesArgs
 *         {
 *             AdditionalProperties = new AzureNative.Subscription.Inputs.PutAliasRequestAdditionalPropertiesArgs
 *             {
 *                 SubscriptionOwnerId = "f09b39eb-c496-482c-9ab9-afd799572f4c",
 *                 SubscriptionTenantId = "66f6e4d6-07dc-4aea-94ea-e12d3026a3c8",
 *                 Tags =
 *                 {
 *                     { "tag1", "Messi" },
 *                     { "tag2", "Ronaldo" },
 *                     { "tag3", "Lebron" },
 *                 },
 *             },
 *             BillingScope = "/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH",
 *             DisplayName = "Test Subscription",
 *             Workload = AzureNative.Subscription.Workload.Production,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/subscription/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := subscription.NewAlias(ctx, "alias", &subscription.AliasArgs{
 * 			AliasName: pulumi.String("aliasForNewSub"),
 * 			Properties: &subscription.PutAliasRequestPropertiesArgs{
 * 				AdditionalProperties: &subscription.PutAliasRequestAdditionalPropertiesArgs{
 * 					SubscriptionOwnerId:  pulumi.String("f09b39eb-c496-482c-9ab9-afd799572f4c"),
 * 					SubscriptionTenantId: pulumi.String("66f6e4d6-07dc-4aea-94ea-e12d3026a3c8"),
 * 					Tags: pulumi.StringMap{
 * 						"tag1": pulumi.String("Messi"),
 * 						"tag2": pulumi.String("Ronaldo"),
 * 						"tag3": pulumi.String("Lebron"),
 * 					},
 * 				},
 * 				BillingScope: pulumi.String("/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH"),
 * 				DisplayName:  pulumi.String("Test Subscription"),
 * 				Workload:     pulumi.String(subscription.WorkloadProduction),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.subscription.Alias;
 * import com.pulumi.azurenative.subscription.AliasArgs;
 * import com.pulumi.azurenative.subscription.inputs.PutAliasRequestPropertiesArgs;
 * import com.pulumi.azurenative.subscription.inputs.PutAliasRequestAdditionalPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var alias = new Alias("alias", AliasArgs.builder()
 *             .aliasName("aliasForNewSub")
 *             .properties(PutAliasRequestPropertiesArgs.builder()
 *                 .additionalProperties(PutAliasRequestAdditionalPropertiesArgs.builder()
 *                     .subscriptionOwnerId("f09b39eb-c496-482c-9ab9-afd799572f4c")
 *                     .subscriptionTenantId("66f6e4d6-07dc-4aea-94ea-e12d3026a3c8")
 *                     .tags(Map.ofEntries(
 *                         Map.entry("tag1", "Messi"),
 *                         Map.entry("tag2", "Ronaldo"),
 *                         Map.entry("tag3", "Lebron")
 *                     ))
 *                     .build())
 *                 .billingScope("/billingAccounts/af6231a7-7f8d-4fcc-a993-dd8466108d07:c663dac6-a9a5-405a-8938-cd903e12ab5b_2019_05_31/billingProfiles/QWDQ-QWHI-AUW-SJDO-DJH/invoiceSections/FEUF-EUHE-ISJ-SKDW-DJH")
 *                 .displayName("Test Subscription")
 *                 .workload("Production")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:subscription:Alias string /providers/Microsoft.Subscription/aliases/{aliasName}
 * ```
 */
public class Alias internal constructor(
    override val javaResource: com.pulumi.azurenative.subscription.Alias,
) : KotlinCustomResource(javaResource, AliasMapper) {
    /**
     * Alias ID.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Subscription Alias response properties.
     */
    public val properties: Output<SubscriptionAliasResponsePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                subscriptionAliasResponsePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource type, Microsoft.Subscription/aliases.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AliasMapper : ResourceMapper<Alias> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.subscription.Alias::class == javaResource::class

    override fun map(javaResource: Resource): Alias = Alias(
        javaResource as
            com.pulumi.azurenative.subscription.Alias,
    )
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alias].
 */
public suspend fun alias(name: String, block: suspend AliasResourceBuilder.() -> Unit): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alias].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alias(name: String): Alias {
    val builder = AliasResourceBuilder()
    builder.name(name)
    return builder.build()
}
