@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin

import com.pulumi.azurenative.subscription.SubscriptionFunctions.getAliasPlain
import com.pulumi.azurenative.subscription.kotlin.inputs.GetAliasPlainArgs
import com.pulumi.azurenative.subscription.kotlin.inputs.GetAliasPlainArgsBuilder
import com.pulumi.azurenative.subscription.kotlin.outputs.GetAliasResult
import com.pulumi.azurenative.subscription.kotlin.outputs.GetAliasResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SubscriptionFunctions {
    /**
     * Get Alias Subscription.
     * Azure REST API version: 2021-10-01.
     * Other available API versions: 2020-09-01.
     * @param argument null
     * @return Subscription Information with the alias.
     */
    public suspend fun getAlias(argument: GetAliasPlainArgs): GetAliasResult =
        toKotlin(getAliasPlain(argument.toJava()).await())

    /**
     * @see [getAlias].
     * @param aliasName AliasName is the name for the subscription creation request. Note that this is not the same as subscription name and this doesn’t have any other lifecycle need beyond the request for subscription creation.
     * @return Subscription Information with the alias.
     */
    public suspend fun getAlias(aliasName: String): GetAliasResult {
        val argument = GetAliasPlainArgs(
            aliasName = aliasName,
        )
        return toKotlin(getAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlias].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;subscription&#46;kotlin&#46;inputs&#46;GetAliasPlainArgs].
     * @return Subscription Information with the alias.
     */
    public suspend fun getAlias(argument: suspend GetAliasPlainArgsBuilder.() -> Unit): GetAliasResult {
        val builder = GetAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAliasPlain(builtArgument.toJava()).await())
    }
}
