@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.inputs

import com.pulumi.azurenative.subscription.inputs.PutAliasRequestPropertiesArgs.builder
import com.pulumi.azurenative.subscription.kotlin.enums.Workload
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Put subscription properties.
 * @property additionalProperties Put alias request additional properties.
 * @property billingScope Billing scope of the subscription.
 * For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
 * For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
 * For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
 * @property displayName The friendly name of the subscription.
 * @property resellerId Reseller Id
 * @property subscriptionId This parameter can be used to create alias for existing subscription Id
 * @property workload The workload type of the subscription. It can be either Production or DevTest.
 */
public data class PutAliasRequestPropertiesArgs(
    public val additionalProperties: Output<PutAliasRequestAdditionalPropertiesArgs>? = null,
    public val billingScope: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val resellerId: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val workload: Output<Either<String, Workload>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.subscription.inputs.PutAliasRequestPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.subscription.inputs.PutAliasRequestPropertiesArgs =
        com.pulumi.azurenative.subscription.inputs.PutAliasRequestPropertiesArgs.builder()
            .additionalProperties(
                additionalProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .billingScope(billingScope?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .resellerId(resellerId?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .workload(
                workload?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PutAliasRequestPropertiesArgs].
 */
@PulumiTagMarker
public class PutAliasRequestPropertiesArgsBuilder internal constructor() {
    private var additionalProperties: Output<PutAliasRequestAdditionalPropertiesArgs>? = null

    private var billingScope: Output<String>? = null

    private var displayName: Output<String>? = null

    private var resellerId: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var workload: Output<Either<String, Workload>>? = null

    /**
     * @param value Put alias request additional properties.
     */
    @JvmName("astupbltooiqkxjg")
    public suspend fun additionalProperties(`value`: Output<PutAliasRequestAdditionalPropertiesArgs>) {
        this.additionalProperties = value
    }

    /**
     * @param value Billing scope of the subscription.
     * For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
     * For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
     * For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
     */
    @JvmName("cnfuturtitqgreql")
    public suspend fun billingScope(`value`: Output<String>) {
        this.billingScope = value
    }

    /**
     * @param value The friendly name of the subscription.
     */
    @JvmName("hifpeajgjfpjwpdn")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Reseller Id
     */
    @JvmName("qiabqenrvekxmwkx")
    public suspend fun resellerId(`value`: Output<String>) {
        this.resellerId = value
    }

    /**
     * @param value This parameter can be used to create alias for existing subscription Id
     */
    @JvmName("vkafikjxywsearlx")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The workload type of the subscription. It can be either Production or DevTest.
     */
    @JvmName("elknmfvutparwqfc")
    public suspend fun workload(`value`: Output<Either<String, Workload>>) {
        this.workload = value
    }

    /**
     * @param value Put alias request additional properties.
     */
    @JvmName("xduqoqciasbyncql")
    public suspend fun additionalProperties(`value`: PutAliasRequestAdditionalPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalProperties = mapped
    }

    /**
     * @param argument Put alias request additional properties.
     */
    @JvmName("rtgieraubarojgla")
    public suspend fun additionalProperties(argument: suspend PutAliasRequestAdditionalPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PutAliasRequestAdditionalPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.additionalProperties = mapped
    }

    /**
     * @param value Billing scope of the subscription.
     * For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
     * For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
     * For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
     */
    @JvmName("ygynyacxhcoancrj")
    public suspend fun billingScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingScope = mapped
    }

    /**
     * @param value The friendly name of the subscription.
     */
    @JvmName("odiovmouircegtrq")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Reseller Id
     */
    @JvmName("qrscpxqbhqqiypsi")
    public suspend fun resellerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resellerId = mapped
    }

    /**
     * @param value This parameter can be used to create alias for existing subscription Id
     */
    @JvmName("sqsytokpdelbnycg")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value The workload type of the subscription. It can be either Production or DevTest.
     */
    @JvmName("nvsiunblkpyupwrm")
    public suspend fun workload(`value`: Either<String, Workload>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workload = mapped
    }

    /**
     * @param value The workload type of the subscription. It can be either Production or DevTest.
     */
    @JvmName("hyjohxtdvermtkyi")
    public fun workload(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Workload>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workload = mapped
    }

    /**
     * @param value The workload type of the subscription. It can be either Production or DevTest.
     */
    @JvmName("xkhrtlgboorxogek")
    public fun workload(`value`: Workload) {
        val toBeMapped = Either.ofRight<String, Workload>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workload = mapped
    }

    internal fun build(): PutAliasRequestPropertiesArgs = PutAliasRequestPropertiesArgs(
        additionalProperties = additionalProperties,
        billingScope = billingScope,
        displayName = displayName,
        resellerId = resellerId,
        subscriptionId = subscriptionId,
        workload = workload,
    )
}
