@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.subscription.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Put subscription creation result properties.
 * @property acceptOwnershipState The accept ownership state of the resource.
 * @property acceptOwnershipUrl Url to accept ownership of the subscription.
 * @property billingScope Billing scope of the subscription.
 * For CustomerLed and FieldLed - /billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}
 * For PartnerLed - /billingAccounts/{billingAccountName}/customers/{customerName}
 * For Legacy EA - /billingAccounts/{billingAccountName}/enrollmentAccounts/{enrollmentAccountName}
 * @property createdTime Created Time
 * @property displayName The display name of the subscription.
 * @property managementGroupId The Management Group Id.
 * @property provisioningState The provisioning state of the resource.
 * @property resellerId Reseller Id
 * @property subscriptionId Newly created subscription Id.
 * @property subscriptionOwnerId Owner Id of the subscription
 * @property tags Tags for the subscription
 * @property workload The workload type of the subscription. It can be either Production or DevTest.
 */
public data class SubscriptionAliasResponsePropertiesResponse(
    public val acceptOwnershipState: String,
    public val acceptOwnershipUrl: String,
    public val billingScope: String? = null,
    public val createdTime: String? = null,
    public val displayName: String? = null,
    public val managementGroupId: String? = null,
    public val provisioningState: String? = null,
    public val resellerId: String? = null,
    public val subscriptionId: String,
    public val subscriptionOwnerId: String? = null,
    public val tags: Map<String, String>? = null,
    public val workload: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.subscription.outputs.SubscriptionAliasResponsePropertiesResponse): SubscriptionAliasResponsePropertiesResponse = SubscriptionAliasResponsePropertiesResponse(
            acceptOwnershipState = javaType.acceptOwnershipState(),
            acceptOwnershipUrl = javaType.acceptOwnershipUrl(),
            billingScope = javaType.billingScope().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            managementGroupId = javaType.managementGroupId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resellerId = javaType.resellerId().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId(),
            subscriptionOwnerId = javaType.subscriptionOwnerId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            workload = javaType.workload().map({ args0 -> args0 }).orElse(null),
        )
    }
}
