@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.BigDataPoolArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.NodeSize
import com.pulumi.azurenative.synapse.kotlin.enums.NodeSizeFamily
import com.pulumi.azurenative.synapse.kotlin.inputs.AutoPausePropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.AutoPausePropertiesArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.AutoScalePropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.AutoScalePropertiesArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.DynamicExecutorAllocationArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.DynamicExecutorAllocationArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.LibraryInfoArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.LibraryInfoArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.LibraryRequirementsArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.LibraryRequirementsArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.SparkConfigPropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.SparkConfigPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Big Data pool
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-05-01, 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Big Data pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bigDataPool = new AzureNative.Synapse.BigDataPool("bigDataPool", new()
 *     {
 *         AutoPause = new AzureNative.Synapse.Inputs.AutoPausePropertiesArgs
 *         {
 *             DelayInMinutes = 15,
 *             Enabled = true,
 *         },
 *         AutoScale = new AzureNative.Synapse.Inputs.AutoScalePropertiesArgs
 *         {
 *             Enabled = true,
 *             MaxNodeCount = 50,
 *             MinNodeCount = 3,
 *         },
 *         BigDataPoolName = "ExamplePool",
 *         DefaultSparkLogFolder = "/logs",
 *         IsAutotuneEnabled = false,
 *         LibraryRequirements = new AzureNative.Synapse.Inputs.LibraryRequirementsArgs
 *         {
 *             Content = "",
 *             Filename = "requirements.txt",
 *         },
 *         Location = "West US 2",
 *         NodeCount = 4,
 *         NodeSize = AzureNative.Synapse.NodeSize.Medium,
 *         NodeSizeFamily = AzureNative.Synapse.NodeSizeFamily.MemoryOptimized,
 *         ResourceGroupName = "ExampleResourceGroup",
 *         SparkEventsFolder = "/events",
 *         SparkVersion = "3.3",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewBigDataPool(ctx, "bigDataPool", &synapse.BigDataPoolArgs{
 * 			AutoPause: &synapse.AutoPausePropertiesArgs{
 * 				DelayInMinutes: pulumi.Int(15),
 * 				Enabled:        pulumi.Bool(true),
 * 			},
 * 			AutoScale: &synapse.AutoScalePropertiesArgs{
 * 				Enabled:      pulumi.Bool(true),
 * 				MaxNodeCount: pulumi.Int(50),
 * 				MinNodeCount: pulumi.Int(3),
 * 			},
 * 			BigDataPoolName:       pulumi.String("ExamplePool"),
 * 			DefaultSparkLogFolder: pulumi.String("/logs"),
 * 			IsAutotuneEnabled:     pulumi.Bool(false),
 * 			LibraryRequirements: &synapse.LibraryRequirementsArgs{
 * 				Content:  pulumi.String(""),
 * 				Filename: pulumi.String("requirements.txt"),
 * 			},
 * 			Location:          pulumi.String("West US 2"),
 * 			NodeCount:         pulumi.Int(4),
 * 			NodeSize:          pulumi.String(synapse.NodeSizeMedium),
 * 			NodeSizeFamily:    pulumi.String(synapse.NodeSizeFamilyMemoryOptimized),
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			SparkEventsFolder: pulumi.String("/events"),
 * 			SparkVersion:      pulumi.String("3.3"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			WorkspaceName: pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.BigDataPool;
 * import com.pulumi.azurenative.synapse.BigDataPoolArgs;
 * import com.pulumi.azurenative.synapse.inputs.AutoPausePropertiesArgs;
 * import com.pulumi.azurenative.synapse.inputs.AutoScalePropertiesArgs;
 * import com.pulumi.azurenative.synapse.inputs.LibraryRequirementsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bigDataPool = new BigDataPool("bigDataPool", BigDataPoolArgs.builder()
 *             .autoPause(AutoPausePropertiesArgs.builder()
 *                 .delayInMinutes(15)
 *                 .enabled(true)
 *                 .build())
 *             .autoScale(AutoScalePropertiesArgs.builder()
 *                 .enabled(true)
 *                 .maxNodeCount(50)
 *                 .minNodeCount(3)
 *                 .build())
 *             .bigDataPoolName("ExamplePool")
 *             .defaultSparkLogFolder("/logs")
 *             .isAutotuneEnabled(false)
 *             .libraryRequirements(LibraryRequirementsArgs.builder()
 *                 .content("")
 *                 .filename("requirements.txt")
 *                 .build())
 *             .location("West US 2")
 *             .nodeCount(4)
 *             .nodeSize("Medium")
 *             .nodeSizeFamily("MemoryOptimized")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .sparkEventsFolder("/events")
 *             .sparkVersion("3.3")
 *             .tags(Map.of("key", "value"))
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:BigDataPool ExamplePool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/bigDataPools/{bigDataPoolName}
 * ```
 * @property autoPause Auto-pausing properties
 * @property autoScale Auto-scaling properties
 * @property bigDataPoolName Big Data pool name
 * @property cacheSize The cache size
 * @property customLibraries List of custom libraries/packages associated with the spark pool.
 * @property defaultSparkLogFolder The default folder where Spark logs will be written.
 * @property dynamicExecutorAllocation Dynamic Executor Allocation
 * @property force Whether to stop any running jobs in the Big Data pool
 * @property isAutotuneEnabled Whether autotune is required or not.
 * @property isComputeIsolationEnabled Whether compute isolation is required or not.
 * @property libraryRequirements Library version requirements
 * @property location The geo-location where the resource lives
 * @property nodeCount The number of nodes in the Big Data pool.
 * @property nodeSize The level of compute power that each node in the Big Data pool has.
 * @property nodeSizeFamily The kind of nodes that the Big Data pool provides.
 * @property provisioningState The state of the Big Data pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sessionLevelPackagesEnabled Whether session level packages enabled.
 * @property sparkConfigProperties Spark configuration file to specify additional properties
 * @property sparkEventsFolder The Spark events folder
 * @property sparkVersion The Apache Spark version.
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 */
public data class BigDataPoolArgs(
    public val autoPause: Output<AutoPausePropertiesArgs>? = null,
    public val autoScale: Output<AutoScalePropertiesArgs>? = null,
    public val bigDataPoolName: Output<String>? = null,
    public val cacheSize: Output<Int>? = null,
    public val customLibraries: Output<List<LibraryInfoArgs>>? = null,
    public val defaultSparkLogFolder: Output<String>? = null,
    public val dynamicExecutorAllocation: Output<DynamicExecutorAllocationArgs>? = null,
    public val force: Output<Boolean>? = null,
    public val isAutotuneEnabled: Output<Boolean>? = null,
    public val isComputeIsolationEnabled: Output<Boolean>? = null,
    public val libraryRequirements: Output<LibraryRequirementsArgs>? = null,
    public val location: Output<String>? = null,
    public val nodeCount: Output<Int>? = null,
    public val nodeSize: Output<Either<String, NodeSize>>? = null,
    public val nodeSizeFamily: Output<Either<String, NodeSizeFamily>>? = null,
    public val provisioningState: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sessionLevelPackagesEnabled: Output<Boolean>? = null,
    public val sparkConfigProperties: Output<SparkConfigPropertiesArgs>? = null,
    public val sparkEventsFolder: Output<String>? = null,
    public val sparkVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.BigDataPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.BigDataPoolArgs =
        com.pulumi.azurenative.synapse.BigDataPoolArgs.builder()
            .autoPause(autoPause?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoScale(autoScale?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bigDataPoolName(bigDataPoolName?.applyValue({ args0 -> args0 }))
            .cacheSize(cacheSize?.applyValue({ args0 -> args0 }))
            .customLibraries(
                customLibraries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultSparkLogFolder(defaultSparkLogFolder?.applyValue({ args0 -> args0 }))
            .dynamicExecutorAllocation(
                dynamicExecutorAllocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .force(force?.applyValue({ args0 -> args0 }))
            .isAutotuneEnabled(isAutotuneEnabled?.applyValue({ args0 -> args0 }))
            .isComputeIsolationEnabled(isComputeIsolationEnabled?.applyValue({ args0 -> args0 }))
            .libraryRequirements(
                libraryRequirements?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .nodeSize(
                nodeSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nodeSizeFamily(
                nodeSizeFamily?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(provisioningState?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sessionLevelPackagesEnabled(sessionLevelPackagesEnabled?.applyValue({ args0 -> args0 }))
            .sparkConfigProperties(
                sparkConfigProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sparkEventsFolder(sparkEventsFolder?.applyValue({ args0 -> args0 }))
            .sparkVersion(sparkVersion?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BigDataPoolArgs].
 */
@PulumiTagMarker
public class BigDataPoolArgsBuilder internal constructor() {
    private var autoPause: Output<AutoPausePropertiesArgs>? = null

    private var autoScale: Output<AutoScalePropertiesArgs>? = null

    private var bigDataPoolName: Output<String>? = null

    private var cacheSize: Output<Int>? = null

    private var customLibraries: Output<List<LibraryInfoArgs>>? = null

    private var defaultSparkLogFolder: Output<String>? = null

    private var dynamicExecutorAllocation: Output<DynamicExecutorAllocationArgs>? = null

    private var force: Output<Boolean>? = null

    private var isAutotuneEnabled: Output<Boolean>? = null

    private var isComputeIsolationEnabled: Output<Boolean>? = null

    private var libraryRequirements: Output<LibraryRequirementsArgs>? = null

    private var location: Output<String>? = null

    private var nodeCount: Output<Int>? = null

    private var nodeSize: Output<Either<String, NodeSize>>? = null

    private var nodeSizeFamily: Output<Either<String, NodeSizeFamily>>? = null

    private var provisioningState: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sessionLevelPackagesEnabled: Output<Boolean>? = null

    private var sparkConfigProperties: Output<SparkConfigPropertiesArgs>? = null

    private var sparkEventsFolder: Output<String>? = null

    private var sparkVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Auto-pausing properties
     */
    @JvmName("umpinslcxigrbrgk")
    public suspend fun autoPause(`value`: Output<AutoPausePropertiesArgs>) {
        this.autoPause = value
    }

    /**
     * @param value Auto-scaling properties
     */
    @JvmName("miucjxjyqujcyvny")
    public suspend fun autoScale(`value`: Output<AutoScalePropertiesArgs>) {
        this.autoScale = value
    }

    /**
     * @param value Big Data pool name
     */
    @JvmName("udiykwguimjgykrt")
    public suspend fun bigDataPoolName(`value`: Output<String>) {
        this.bigDataPoolName = value
    }

    /**
     * @param value The cache size
     */
    @JvmName("pykbpkpgvpdcfwnq")
    public suspend fun cacheSize(`value`: Output<Int>) {
        this.cacheSize = value
    }

    /**
     * @param value List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("ynxonniaddnldsux")
    public suspend fun customLibraries(`value`: Output<List<LibraryInfoArgs>>) {
        this.customLibraries = value
    }

    @JvmName("dbbyoocyotrsbtwl")
    public suspend fun customLibraries(vararg values: Output<LibraryInfoArgs>) {
        this.customLibraries = Output.all(values.asList())
    }

    /**
     * @param values List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("qpycgdvrdysckrxe")
    public suspend fun customLibraries(values: List<Output<LibraryInfoArgs>>) {
        this.customLibraries = Output.all(values)
    }

    /**
     * @param value The default folder where Spark logs will be written.
     */
    @JvmName("klrsjtsbdpgshcpq")
    public suspend fun defaultSparkLogFolder(`value`: Output<String>) {
        this.defaultSparkLogFolder = value
    }

    /**
     * @param value Dynamic Executor Allocation
     */
    @JvmName("fqcqhckaaruvsmvj")
    public suspend fun dynamicExecutorAllocation(`value`: Output<DynamicExecutorAllocationArgs>) {
        this.dynamicExecutorAllocation = value
    }

    /**
     * @param value Whether to stop any running jobs in the Big Data pool
     */
    @JvmName("qihhjxemuelobtdi")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value Whether autotune is required or not.
     */
    @JvmName("xwgssllvktklkady")
    public suspend fun isAutotuneEnabled(`value`: Output<Boolean>) {
        this.isAutotuneEnabled = value
    }

    /**
     * @param value Whether compute isolation is required or not.
     */
    @JvmName("krmaonvrpbnbssdu")
    public suspend fun isComputeIsolationEnabled(`value`: Output<Boolean>) {
        this.isComputeIsolationEnabled = value
    }

    /**
     * @param value Library version requirements
     */
    @JvmName("ufenvfvqujilkxtu")
    public suspend fun libraryRequirements(`value`: Output<LibraryRequirementsArgs>) {
        this.libraryRequirements = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wkbchykteabmumdk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The number of nodes in the Big Data pool.
     */
    @JvmName("gpooflbogyepsdve")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value The level of compute power that each node in the Big Data pool has.
     */
    @JvmName("gfmtvrllhhsyaxph")
    public suspend fun nodeSize(`value`: Output<Either<String, NodeSize>>) {
        this.nodeSize = value
    }

    /**
     * @param value The kind of nodes that the Big Data pool provides.
     */
    @JvmName("qdswofxdqpwtaefy")
    public suspend fun nodeSizeFamily(`value`: Output<Either<String, NodeSizeFamily>>) {
        this.nodeSizeFamily = value
    }

    /**
     * @param value The state of the Big Data pool.
     */
    @JvmName("nrsjxtidpnpplfip")
    public suspend fun provisioningState(`value`: Output<String>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sccwhvchwvawhhuo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Whether session level packages enabled.
     */
    @JvmName("cvqxtfkmybdweips")
    public suspend fun sessionLevelPackagesEnabled(`value`: Output<Boolean>) {
        this.sessionLevelPackagesEnabled = value
    }

    /**
     * @param value Spark configuration file to specify additional properties
     */
    @JvmName("liphpwtwqudyyaem")
    public suspend fun sparkConfigProperties(`value`: Output<SparkConfigPropertiesArgs>) {
        this.sparkConfigProperties = value
    }

    /**
     * @param value The Spark events folder
     */
    @JvmName("krrnnhdyauixhnuy")
    public suspend fun sparkEventsFolder(`value`: Output<String>) {
        this.sparkEventsFolder = value
    }

    /**
     * @param value The Apache Spark version.
     */
    @JvmName("wdsxcnmcitcisamc")
    public suspend fun sparkVersion(`value`: Output<String>) {
        this.sparkVersion = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dweplwouwcodteve")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("uhhqlplndokvfmiv")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Auto-pausing properties
     */
    @JvmName("weoufribxrwlaoqj")
    public suspend fun autoPause(`value`: AutoPausePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPause = mapped
    }

    /**
     * @param argument Auto-pausing properties
     */
    @JvmName("naljnhaabahornlm")
    public suspend fun autoPause(argument: suspend AutoPausePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoPausePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoPause = mapped
    }

    /**
     * @param value Auto-scaling properties
     */
    @JvmName("jurcfqmqpvrlshmn")
    public suspend fun autoScale(`value`: AutoScalePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScale = mapped
    }

    /**
     * @param argument Auto-scaling properties
     */
    @JvmName("lbnjfoisvfmjayyh")
    public suspend fun autoScale(argument: suspend AutoScalePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AutoScalePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoScale = mapped
    }

    /**
     * @param value Big Data pool name
     */
    @JvmName("ayvcqdgmnvnibfpa")
    public suspend fun bigDataPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bigDataPoolName = mapped
    }

    /**
     * @param value The cache size
     */
    @JvmName("jwtbwtwmqldmyjud")
    public suspend fun cacheSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheSize = mapped
    }

    /**
     * @param value List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("itjnwlrcnfewdjwr")
    public suspend fun customLibraries(`value`: List<LibraryInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLibraries = mapped
    }

    /**
     * @param argument List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("kpwgfyrbofppkacl")
    public suspend fun customLibraries(argument: List<suspend LibraryInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LibraryInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.customLibraries = mapped
    }

    /**
     * @param argument List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("pdnbwjdhwkxaxvuc")
    public suspend fun customLibraries(vararg argument: suspend LibraryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LibraryInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.customLibraries = mapped
    }

    /**
     * @param argument List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("gketxtmscpxgiyhn")
    public suspend fun customLibraries(argument: suspend LibraryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LibraryInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.customLibraries = mapped
    }

    /**
     * @param values List of custom libraries/packages associated with the spark pool.
     */
    @JvmName("xusfeaaswtagefye")
    public suspend fun customLibraries(vararg values: LibraryInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customLibraries = mapped
    }

    /**
     * @param value The default folder where Spark logs will be written.
     */
    @JvmName("gvjwlvbeslmaxktc")
    public suspend fun defaultSparkLogFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSparkLogFolder = mapped
    }

    /**
     * @param value Dynamic Executor Allocation
     */
    @JvmName("uuaameugpguuufgr")
    public suspend fun dynamicExecutorAllocation(`value`: DynamicExecutorAllocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynamicExecutorAllocation = mapped
    }

    /**
     * @param argument Dynamic Executor Allocation
     */
    @JvmName("smwwefrvffemaacs")
    public suspend fun dynamicExecutorAllocation(argument: suspend DynamicExecutorAllocationArgsBuilder.() -> Unit) {
        val toBeMapped = DynamicExecutorAllocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dynamicExecutorAllocation = mapped
    }

    /**
     * @param value Whether to stop any running jobs in the Big Data pool
     */
    @JvmName("ajonnnbytkebnhkv")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value Whether autotune is required or not.
     */
    @JvmName("swcfcojewflayrpw")
    public suspend fun isAutotuneEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isAutotuneEnabled = mapped
    }

    /**
     * @param value Whether compute isolation is required or not.
     */
    @JvmName("aaltnvurnyvdrvoq")
    public suspend fun isComputeIsolationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isComputeIsolationEnabled = mapped
    }

    /**
     * @param value Library version requirements
     */
    @JvmName("eblceuesohbjgxcs")
    public suspend fun libraryRequirements(`value`: LibraryRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.libraryRequirements = mapped
    }

    /**
     * @param argument Library version requirements
     */
    @JvmName("pltkyabykcxhugbv")
    public suspend fun libraryRequirements(argument: suspend LibraryRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = LibraryRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.libraryRequirements = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("otuvoqlwfxuuclxe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The number of nodes in the Big Data pool.
     */
    @JvmName("yvurotpsgxlufjfc")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value The level of compute power that each node in the Big Data pool has.
     */
    @JvmName("degvwqbhwmlioags")
    public suspend fun nodeSize(`value`: Either<String, NodeSize>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSize = mapped
    }

    /**
     * @param value The level of compute power that each node in the Big Data pool has.
     */
    @JvmName("ahkfwislyllhadke")
    public fun nodeSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NodeSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSize = mapped
    }

    /**
     * @param value The level of compute power that each node in the Big Data pool has.
     */
    @JvmName("fehbtvppxwdgaeoh")
    public fun nodeSize(`value`: NodeSize) {
        val toBeMapped = Either.ofRight<String, NodeSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSize = mapped
    }

    /**
     * @param value The kind of nodes that the Big Data pool provides.
     */
    @JvmName("ehtdogeohsyjbehb")
    public suspend fun nodeSizeFamily(`value`: Either<String, NodeSizeFamily>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeSizeFamily = mapped
    }

    /**
     * @param value The kind of nodes that the Big Data pool provides.
     */
    @JvmName("jjpsrbnowvcdlfdq")
    public fun nodeSizeFamily(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NodeSizeFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSizeFamily = mapped
    }

    /**
     * @param value The kind of nodes that the Big Data pool provides.
     */
    @JvmName("tuurerjkccborsxy")
    public fun nodeSizeFamily(`value`: NodeSizeFamily) {
        val toBeMapped = Either.ofRight<String, NodeSizeFamily>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSizeFamily = mapped
    }

    /**
     * @param value The state of the Big Data pool.
     */
    @JvmName("oacyykehmiafhlrb")
    public suspend fun provisioningState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oxxhsrvprpegvokw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Whether session level packages enabled.
     */
    @JvmName("rdtnxkmjrdohuctt")
    public suspend fun sessionLevelPackagesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionLevelPackagesEnabled = mapped
    }

    /**
     * @param value Spark configuration file to specify additional properties
     */
    @JvmName("kkmdcshyojphqrya")
    public suspend fun sparkConfigProperties(`value`: SparkConfigPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkConfigProperties = mapped
    }

    /**
     * @param argument Spark configuration file to specify additional properties
     */
    @JvmName("ecdcdrgmbqcighcd")
    public suspend fun sparkConfigProperties(argument: suspend SparkConfigPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SparkConfigPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sparkConfigProperties = mapped
    }

    /**
     * @param value The Spark events folder
     */
    @JvmName("dktdgddcfqwerncf")
    public suspend fun sparkEventsFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkEventsFolder = mapped
    }

    /**
     * @param value The Apache Spark version.
     */
    @JvmName("ayuumyagurhgjpae")
    public suspend fun sparkVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sparkVersion = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ktpxwonplofjmjyx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ypjdxupcamtafsce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pcxstdwkufdpuglk")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): BigDataPoolArgs = BigDataPoolArgs(
        autoPause = autoPause,
        autoScale = autoScale,
        bigDataPoolName = bigDataPoolName,
        cacheSize = cacheSize,
        customLibraries = customLibraries,
        defaultSparkLogFolder = defaultSparkLogFolder,
        dynamicExecutorAllocation = dynamicExecutorAllocation,
        force = force,
        isAutotuneEnabled = isAutotuneEnabled,
        isComputeIsolationEnabled = isComputeIsolationEnabled,
        libraryRequirements = libraryRequirements,
        location = location,
        nodeCount = nodeCount,
        nodeSize = nodeSize,
        nodeSizeFamily = nodeSizeFamily,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
        sessionLevelPackagesEnabled = sessionLevelPackagesEnabled,
        sparkConfigProperties = sparkConfigProperties,
        sparkEventsFolder = sparkEventsFolder,
        sparkVersion = sparkVersion,
        tags = tags,
        workspaceName = workspaceName,
    )
}
