@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DatabasePrincipalAssignment].
 */
@PulumiTagMarker
public class DatabasePrincipalAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabasePrincipalAssignmentArgs = DatabasePrincipalAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabasePrincipalAssignmentArgsBuilder.() -> Unit) {
        val builder = DatabasePrincipalAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DatabasePrincipalAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.DatabasePrincipalAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabasePrincipalAssignment(builtJavaResource)
    }
}

/**
 * Class representing a database principal assignment.
 * Azure REST API version: 2021-04-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasePrincipalAssignmentsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databasePrincipalAssignment = new AzureNative.Synapse.DatabasePrincipalAssignment("databasePrincipalAssignment", new()
 *     {
 *         DatabaseName = "Kustodatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         PrincipalAssignmentName = "kustoprincipal1",
 *         PrincipalId = "87654321-1234-1234-1234-123456789123",
 *         PrincipalType = AzureNative.Synapse.PrincipalType.App,
 *         ResourceGroupName = "kustorptest",
 *         Role = AzureNative.Synapse.DatabasePrincipalRole.Admin,
 *         TenantId = "12345678-1234-1234-1234-123456789123",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewDatabasePrincipalAssignment(ctx, "databasePrincipalAssignment", &synapse.DatabasePrincipalAssignmentArgs{
 * 			DatabaseName:            pulumi.String("Kustodatabase8"),
 * 			KustoPoolName:           pulumi.String("kustoclusterrptest4"),
 * 			PrincipalAssignmentName: pulumi.String("kustoprincipal1"),
 * 			PrincipalId:             pulumi.String("87654321-1234-1234-1234-123456789123"),
 * 			PrincipalType:           pulumi.String(synapse.PrincipalTypeApp),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			Role:                    pulumi.String(synapse.DatabasePrincipalRoleAdmin),
 * 			TenantId:                pulumi.String("12345678-1234-1234-1234-123456789123"),
 * 			WorkspaceName:           pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.DatabasePrincipalAssignment;
 * import com.pulumi.azurenative.synapse.DatabasePrincipalAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databasePrincipalAssignment = new DatabasePrincipalAssignment("databasePrincipalAssignment", DatabasePrincipalAssignmentArgs.builder()
 *             .databaseName("Kustodatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .principalAssignmentName("kustoprincipal1")
 *             .principalId("87654321-1234-1234-1234-123456789123")
 *             .principalType("App")
 *             .resourceGroupName("kustorptest")
 *             .role("Admin")
 *             .tenantId("12345678-1234-1234-1234-123456789123")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:DatabasePrincipalAssignment synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}/principalAssignments/{principalAssignmentName}
 * ```
 */
public class DatabasePrincipalAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.DatabasePrincipalAssignment,
) : KotlinCustomResource(javaResource, DatabasePrincipalAssignmentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The principal name
     */
    public val principalName: Output<String>
        get() = javaResource.principalName().applyValue({ args0 -> args0 })

    /**
     * Principal type.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Database principal role.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tenant id of the principal
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tenant name of the principal
     */
    public val tenantName: Output<String>
        get() = javaResource.tenantName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabasePrincipalAssignmentMapper : ResourceMapper<DatabasePrincipalAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.DatabasePrincipalAssignment::class == javaResource::class

    override fun map(javaResource: Resource): DatabasePrincipalAssignment =
        DatabasePrincipalAssignment(
            javaResource as
                com.pulumi.azurenative.synapse.DatabasePrincipalAssignment,
        )
}

/**
 * @see [DatabasePrincipalAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabasePrincipalAssignment].
 */
public suspend fun databasePrincipalAssignment(
    name: String,
    block: suspend DatabasePrincipalAssignmentResourceBuilder.() -> Unit,
): DatabasePrincipalAssignment {
    val builder = DatabasePrincipalAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabasePrincipalAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databasePrincipalAssignment(name: String): DatabasePrincipalAssignment {
    val builder = DatabasePrincipalAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
