@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Key].
 */
@PulumiTagMarker
public class KeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyArgs = KeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyArgsBuilder.() -> Unit) {
        val builder = KeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Key {
        val builtJavaResource = com.pulumi.azurenative.synapse.Key(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Key(builtJavaResource)
    }
}

/**
 * A workspace key
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a workspace key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AzureNative.Synapse.Key("key", new()
 *     {
 *         IsActiveCMK = true,
 *         KeyName = "somekey",
 *         KeyVaultUrl = "https://vault.azure.net/keys/somesecret",
 *         ResourceGroupName = "ExampleResourceGroup",
 *         WorkspaceName = "ExampleWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKey(ctx, "key", &synapse.KeyArgs{
 * 			IsActiveCMK:       pulumi.Bool(true),
 * 			KeyName:           pulumi.String("somekey"),
 * 			KeyVaultUrl:       pulumi.String("https://vault.azure.net/keys/somesecret"),
 * 			ResourceGroupName: pulumi.String("ExampleResourceGroup"),
 * 			WorkspaceName:     pulumi.String("ExampleWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.Key;
 * import com.pulumi.azurenative.synapse.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .isActiveCMK(true)
 *             .keyName("somekey")
 *             .keyVaultUrl("https://vault.azure.net/keys/somesecret")
 *             .resourceGroupName("ExampleResourceGroup")
 *             .workspaceName("ExampleWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:Key somekey /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/keys/{keyName}
 * ```
 */
public class Key internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.Key,
) : KotlinCustomResource(javaResource, KeyMapper) {
    /**
     * Used to activate the workspace after a customer managed key is provided.
     */
    public val isActiveCMK: Output<Boolean>?
        get() = javaResource.isActiveCMK().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Key Vault Url of the workspace key.
     */
    public val keyVaultUrl: Output<String>?
        get() = javaResource.keyVaultUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KeyMapper : ResourceMapper<Key> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.Key::class == javaResource::class

    override fun map(javaResource: Resource): Key = Key(
        javaResource as
            com.pulumi.azurenative.synapse.Key,
    )
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Key].
 */
public suspend fun key(name: String, block: suspend KeyResourceBuilder.() -> Unit): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 */
public fun key(name: String): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
