@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.DefaultPrincipalsModificationKind
import com.pulumi.azurenative.synapse.kotlin.inputs.TableLevelSharingPropertiesArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.TableLevelSharingPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class representing an attached database configuration.
 * Azure REST API version: 2021-06-01-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolAttachedDatabaseConfigurationsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPoolAttachedDatabaseConfiguration = new AzureNative.Synapse.KustoPoolAttachedDatabaseConfiguration("kustoPoolAttachedDatabaseConfiguration", new()
 *     {
 *         AttachedDatabaseConfigurationName = "attachedDatabaseConfigurations1",
 *         DatabaseName = "kustodatabase",
 *         DefaultPrincipalsModificationKind = AzureNative.Synapse.DefaultPrincipalsModificationKind.Union,
 *         KustoPoolName = "kustoclusterrptest4",
 *         KustoPoolResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         TableLevelSharingProperties = new AzureNative.Synapse.Inputs.TableLevelSharingPropertiesArgs
 *         {
 *             ExternalTablesToExclude = new[]
 *             {
 *                 "ExternalTable2",
 *             },
 *             ExternalTablesToInclude = new[]
 *             {
 *                 "ExternalTable1",
 *             },
 *             MaterializedViewsToExclude = new[]
 *             {
 *                 "MaterializedViewTable2",
 *             },
 *             MaterializedViewsToInclude = new[]
 *             {
 *                 "MaterializedViewTable1",
 *             },
 *             TablesToExclude = new[]
 *             {
 *                 "Table2",
 *             },
 *             TablesToInclude = new[]
 *             {
 *                 "Table1",
 *             },
 *         },
 *         WorkspaceName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPoolAttachedDatabaseConfiguration(ctx, "kustoPoolAttachedDatabaseConfiguration", &synapse.KustoPoolAttachedDatabaseConfigurationArgs{
 * 			AttachedDatabaseConfigurationName: pulumi.String("attachedDatabaseConfigurations1"),
 * 			DatabaseName:                      pulumi.String("kustodatabase"),
 * 			DefaultPrincipalsModificationKind: pulumi.String(synapse.DefaultPrincipalsModificationKindUnion),
 * 			KustoPoolName:                     pulumi.String("kustoclusterrptest4"),
 * 			KustoPoolResourceId:               pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4"),
 * 			Location:                          pulumi.String("westus"),
 * 			ResourceGroupName:                 pulumi.String("kustorptest"),
 * 			TableLevelSharingProperties: &synapse.TableLevelSharingPropertiesArgs{
 * 				ExternalTablesToExclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable2"),
 * 				},
 * 				ExternalTablesToInclude: pulumi.StringArray{
 * 					pulumi.String("ExternalTable1"),
 * 				},
 * 				MaterializedViewsToExclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable2"),
 * 				},
 * 				MaterializedViewsToInclude: pulumi.StringArray{
 * 					pulumi.String("MaterializedViewTable1"),
 * 				},
 * 				TablesToExclude: pulumi.StringArray{
 * 					pulumi.String("Table2"),
 * 				},
 * 				TablesToInclude: pulumi.StringArray{
 * 					pulumi.String("Table1"),
 * 				},
 * 			},
 * 			WorkspaceName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfiguration;
 * import com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs;
 * import com.pulumi.azurenative.synapse.inputs.TableLevelSharingPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPoolAttachedDatabaseConfiguration = new KustoPoolAttachedDatabaseConfiguration("kustoPoolAttachedDatabaseConfiguration", KustoPoolAttachedDatabaseConfigurationArgs.builder()
 *             .attachedDatabaseConfigurationName("attachedDatabaseConfigurations1")
 *             .databaseName("kustodatabase")
 *             .defaultPrincipalsModificationKind("Union")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .kustoPoolResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/Workspaces/kustorptest/KustoPools/kustoclusterrptest4")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .tableLevelSharingProperties(TableLevelSharingPropertiesArgs.builder()
 *                 .externalTablesToExclude("ExternalTable2")
 *                 .externalTablesToInclude("ExternalTable1")
 *                 .materializedViewsToExclude("MaterializedViewTable2")
 *                 .materializedViewsToInclude("MaterializedViewTable1")
 *                 .tablesToExclude("Table2")
 *                 .tablesToInclude("Table1")
 *                 .build())
 *             .workspaceName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPoolAttachedDatabaseConfiguration KustoClusterRPTest4/attachedDatabaseConfigurations1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/attachedDatabaseConfigurations/{attachedDatabaseConfigurationName}
 * ```
 * @property attachedDatabaseConfigurationName The name of the attached database configuration.
 * @property databaseName The name of the database which you would like to attach, use * if you want to follow all current and future databases.
 * @property defaultPrincipalsModificationKind The default principals modification kind
 * @property kustoPoolName The name of the Kusto pool.
 * @property kustoPoolResourceId The resource id of the kusto pool where the databases you would like to attach reside.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tableLevelSharingProperties Table level sharing specifications
 * @property workspaceName The name of the workspace.
 */
public data class KustoPoolAttachedDatabaseConfigurationArgs(
    public val attachedDatabaseConfigurationName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val defaultPrincipalsModificationKind: Output<Either<String, DefaultPrincipalsModificationKind>>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val kustoPoolResourceId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs =
        com.pulumi.azurenative.synapse.KustoPoolAttachedDatabaseConfigurationArgs.builder()
            .attachedDatabaseConfigurationName(
                attachedDatabaseConfigurationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .defaultPrincipalsModificationKind(
                defaultPrincipalsModificationKind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .kustoPoolResourceId(kustoPoolResourceId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tableLevelSharingProperties(
                tableLevelSharingProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustoPoolAttachedDatabaseConfigurationArgs].
 */
@PulumiTagMarker
public class KustoPoolAttachedDatabaseConfigurationArgsBuilder internal constructor() {
    private var attachedDatabaseConfigurationName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var defaultPrincipalsModificationKind:
        Output<Either<String, DefaultPrincipalsModificationKind>>? = null

    private var kustoPoolName: Output<String>? = null

    private var kustoPoolResourceId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tableLevelSharingProperties: Output<TableLevelSharingPropertiesArgs>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("dpidplrcpsfqxstn")
    public suspend fun attachedDatabaseConfigurationName(`value`: Output<String>) {
        this.attachedDatabaseConfigurationName = value
    }

    /**
     * @param value The name of the database which you would like to attach, use * if you want to follow all current and future databases.
     */
    @JvmName("egmepingaxjotqyc")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("jenmngswnvbwsebv")
    public suspend fun defaultPrincipalsModificationKind(`value`: Output<Either<String, DefaultPrincipalsModificationKind>>) {
        this.defaultPrincipalsModificationKind = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("iiugynkyjuftbaal")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value The resource id of the kusto pool where the databases you would like to attach reside.
     */
    @JvmName("nfnhhuxbmohamuwr")
    public suspend fun kustoPoolResourceId(`value`: Output<String>) {
        this.kustoPoolResourceId = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xqnsxxxpljeppfuu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vvomoscasnxgmiyl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Table level sharing specifications
     */
    @JvmName("vnytdysphubvlmtt")
    public suspend fun tableLevelSharingProperties(`value`: Output<TableLevelSharingPropertiesArgs>) {
        this.tableLevelSharingProperties = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wxagjgdhpnxkaajh")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("adostoovclnpdcdu")
    public suspend fun attachedDatabaseConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedDatabaseConfigurationName = mapped
    }

    /**
     * @param value The name of the database which you would like to attach, use * if you want to follow all current and future databases.
     */
    @JvmName("ogasdrpegqcnnlus")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("aedshjnlbvbygqop")
    public suspend fun defaultPrincipalsModificationKind(`value`: Either<String, DefaultPrincipalsModificationKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("oqclsoxddfduqfbk")
    public fun defaultPrincipalsModificationKind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefaultPrincipalsModificationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value The default principals modification kind
     */
    @JvmName("dpaqmqoixdidkvfb")
    public fun defaultPrincipalsModificationKind(`value`: DefaultPrincipalsModificationKind) {
        val toBeMapped = Either.ofRight<String, DefaultPrincipalsModificationKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultPrincipalsModificationKind = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("spklthvmteoypkou")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The resource id of the kusto pool where the databases you would like to attach reside.
     */
    @JvmName("xvyuhbchcwdjbryk")
    public suspend fun kustoPoolResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolResourceId = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("pesompekvnpvpqlt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ahmolnrmmggeoqma")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Table level sharing specifications
     */
    @JvmName("vjqojqmmlkatmkwl")
    public suspend fun tableLevelSharingProperties(`value`: TableLevelSharingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableLevelSharingProperties = mapped
    }

    /**
     * @param argument Table level sharing specifications
     */
    @JvmName("ujsiqpharyyujpty")
    public suspend fun tableLevelSharingProperties(argument: suspend TableLevelSharingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableLevelSharingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tableLevelSharingProperties = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("jdensbnskpmmwvss")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): KustoPoolAttachedDatabaseConfigurationArgs =
        KustoPoolAttachedDatabaseConfigurationArgs(
            attachedDatabaseConfigurationName = attachedDatabaseConfigurationName,
            databaseName = databaseName,
            defaultPrincipalsModificationKind = defaultPrincipalsModificationKind,
            kustoPoolName = kustoPoolName,
            kustoPoolResourceId = kustoPoolResourceId,
            location = location,
            resourceGroupName = resourceGroupName,
            tableLevelSharingProperties = tableLevelSharingProperties,
            workspaceName = workspaceName,
        )
}
