@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignmentArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.DatabasePrincipalRole
import com.pulumi.azurenative.synapse.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a database principal assignment.
 * Azure REST API version: 2021-06-01-preview.
 * ## Example Usage
 * ### KustoPoolDatabasePrincipalAssignmentsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoPoolDatabasePrincipalAssignment = new AzureNative.Synapse.KustoPoolDatabasePrincipalAssignment("kustoPoolDatabasePrincipalAssignment", new()
 *     {
 *         DatabaseName = "Kustodatabase8",
 *         KustoPoolName = "kustoclusterrptest4",
 *         PrincipalAssignmentName = "kustoprincipal1",
 *         PrincipalId = "87654321-1234-1234-1234-123456789123",
 *         PrincipalType = AzureNative.Synapse.PrincipalType.App,
 *         ResourceGroupName = "kustorptest",
 *         Role = AzureNative.Synapse.DatabasePrincipalRole.Admin,
 *         TenantId = "12345678-1234-1234-1234-123456789123",
 *         WorkspaceName = "synapseWorkspaceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewKustoPoolDatabasePrincipalAssignment(ctx, "kustoPoolDatabasePrincipalAssignment", &synapse.KustoPoolDatabasePrincipalAssignmentArgs{
 * 			DatabaseName:            pulumi.String("Kustodatabase8"),
 * 			KustoPoolName:           pulumi.String("kustoclusterrptest4"),
 * 			PrincipalAssignmentName: pulumi.String("kustoprincipal1"),
 * 			PrincipalId:             pulumi.String("87654321-1234-1234-1234-123456789123"),
 * 			PrincipalType:           pulumi.String(synapse.PrincipalTypeApp),
 * 			ResourceGroupName:       pulumi.String("kustorptest"),
 * 			Role:                    pulumi.String(synapse.DatabasePrincipalRoleAdmin),
 * 			TenantId:                pulumi.String("12345678-1234-1234-1234-123456789123"),
 * 			WorkspaceName:           pulumi.String("synapseWorkspaceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignment;
 * import com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoPoolDatabasePrincipalAssignment = new KustoPoolDatabasePrincipalAssignment("kustoPoolDatabasePrincipalAssignment", KustoPoolDatabasePrincipalAssignmentArgs.builder()
 *             .databaseName("Kustodatabase8")
 *             .kustoPoolName("kustoclusterrptest4")
 *             .principalAssignmentName("kustoprincipal1")
 *             .principalId("87654321-1234-1234-1234-123456789123")
 *             .principalType("App")
 *             .resourceGroupName("kustorptest")
 *             .role("Admin")
 *             .tenantId("12345678-1234-1234-1234-123456789123")
 *             .workspaceName("synapseWorkspaceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:KustoPoolDatabasePrincipalAssignment synapseWorkspaceName/kustoclusterrptest4/Kustodatabase8/kustoprincipal1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/kustoPools/{kustoPoolName}/databases/{databaseName}/principalAssignments/{principalAssignmentName}
 * ```
 * @property databaseName The name of the database in the Kusto pool.
 * @property kustoPoolName The name of the Kusto pool.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property principalId The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
 * @property principalType Principal type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property role Database principal role.
 * @property tenantId The tenant id of the principal
 * @property workspaceName The name of the workspace.
 */
public data class KustoPoolDatabasePrincipalAssignmentArgs(
    public val databaseName: Output<String>? = null,
    public val kustoPoolName: Output<String>? = null,
    public val principalAssignmentName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val role: Output<Either<String, DatabasePrincipalRole>>? = null,
    public val tenantId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignmentArgs =
        com.pulumi.azurenative.synapse.KustoPoolDatabasePrincipalAssignmentArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .kustoPoolName(kustoPoolName?.applyValue({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustoPoolDatabasePrincipalAssignmentArgs].
 */
@PulumiTagMarker
public class KustoPoolDatabasePrincipalAssignmentArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var kustoPoolName: Output<String>? = null

    private var principalAssignmentName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var role: Output<Either<String, DatabasePrincipalRole>>? = null

    private var tenantId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("vbquxvuyvfichocx")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("gktlyqtptmquknfi")
    public suspend fun kustoPoolName(`value`: Output<String>) {
        this.kustoPoolName = value
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("tqiredgokwoghlwc")
    public suspend fun principalAssignmentName(`value`: Output<String>) {
        this.principalAssignmentName = value
    }

    /**
     * @param value The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("ituifqaecusjjrnd")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Principal type.
     */
    @JvmName("wypuwabcvagftylo")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rimjdialvgrlygcy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("xuiwmctexuxhvisn")
    public suspend fun role(`value`: Output<Either<String, DatabasePrincipalRole>>) {
        this.role = value
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("hpfkbexaoulqgnqy")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kekvkpcrulhylxng")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the database in the Kusto pool.
     */
    @JvmName("bdkktupxrrmrpxqy")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("dennwatscgpsciht")
    public suspend fun kustoPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("yiyrpatblyuxpqht")
    public suspend fun principalAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
     */
    @JvmName("nvblbgimjbijvssl")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("wmtfgrawedwtjxvh")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("rggxmhvxitgwnmgy")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value Principal type.
     */
    @JvmName("iokiwyswmkieppki")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tgqnyxwydxvadgef")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("pxpmopchvuwcxiuf")
    public suspend fun role(`value`: Either<String, DatabasePrincipalRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("xqtijirloqgfilik")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabasePrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Database principal role.
     */
    @JvmName("flcjiscurmotdtnk")
    public fun role(`value`: DatabasePrincipalRole) {
        val toBeMapped = Either.ofRight<String, DatabasePrincipalRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The tenant id of the principal
     */
    @JvmName("adjxdqleodymflwf")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("gltkuumljiokccjr")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): KustoPoolDatabasePrincipalAssignmentArgs =
        KustoPoolDatabasePrincipalAssignmentArgs(
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            principalAssignmentName = principalAssignmentName,
            principalId = principalId,
            principalType = principalType,
            resourceGroupName = resourceGroupName,
            role = role,
            tenantId = tenantId,
            workspaceName = workspaceName,
        )
}
