@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlPoolWorkloadGroup].
 */
@PulumiTagMarker
public class SqlPoolWorkloadGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlPoolWorkloadGroupArgs = SqlPoolWorkloadGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlPoolWorkloadGroupArgsBuilder.() -> Unit) {
        val builder = SqlPoolWorkloadGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlPoolWorkloadGroup {
        val builtJavaResource =
            com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlPoolWorkloadGroup(builtJavaResource)
    }
}

/**
 * Workload group operations for a sql pool
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create a workload group with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadGroup = new AzureNative.Synapse.SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", new()
 *     {
 *         Importance = "normal",
 *         MaxResourcePercent = 100,
 *         MaxResourcePercentPerRequest = 3,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         QueryExecutionTimeout = 0,
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadGroupName = "smallrc",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadGroup(ctx, "sqlPoolWorkloadGroup", &synapse.SqlPoolWorkloadGroupArgs{
 * 			Importance:                   pulumi.String("normal"),
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MaxResourcePercentPerRequest: pulumi.Float64(3),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			QueryExecutionTimeout:        pulumi.Int(0),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                  pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 			WorkspaceName:                pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadGroup = new SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", SqlPoolWorkloadGroupArgs.builder()
 *             .importance("normal")
 *             .maxResourcePercent(100)
 *             .maxResourcePercentPerRequest(3)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .queryExecutionTimeout(0)
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadGroupName("smallrc")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a workload group with the required properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlPoolWorkloadGroup = new AzureNative.Synapse.SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", new()
 *     {
 *         MaxResourcePercent = 100,
 *         MinResourcePercent = 0,
 *         MinResourcePercentPerRequest = 3,
 *         ResourceGroupName = "sqlcrudtest-6852",
 *         SqlPoolName = "sqlcrudtest-9187",
 *         WorkloadGroupName = "smallrc",
 *         WorkspaceName = "sqlcrudtest-2080",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewSqlPoolWorkloadGroup(ctx, "sqlPoolWorkloadGroup", &synapse.SqlPoolWorkloadGroupArgs{
 * 			MaxResourcePercent:           pulumi.Int(100),
 * 			MinResourcePercent:           pulumi.Int(0),
 * 			MinResourcePercentPerRequest: pulumi.Float64(3),
 * 			ResourceGroupName:            pulumi.String("sqlcrudtest-6852"),
 * 			SqlPoolName:                  pulumi.String("sqlcrudtest-9187"),
 * 			WorkloadGroupName:            pulumi.String("smallrc"),
 * 			WorkspaceName:                pulumi.String("sqlcrudtest-2080"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup;
 * import com.pulumi.azurenative.synapse.SqlPoolWorkloadGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlPoolWorkloadGroup = new SqlPoolWorkloadGroup("sqlPoolWorkloadGroup", SqlPoolWorkloadGroupArgs.builder()
 *             .maxResourcePercent(100)
 *             .minResourcePercent(0)
 *             .minResourcePercentPerRequest(3)
 *             .resourceGroupName("sqlcrudtest-6852")
 *             .sqlPoolName("sqlcrudtest-9187")
 *             .workloadGroupName("smallrc")
 *             .workspaceName("sqlcrudtest-2080")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:SqlPoolWorkloadGroup smallrc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/sqlPools/{sqlPoolName}/workloadGroups/{workloadGroupName}
 * ```
 */
public class SqlPoolWorkloadGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup,
) : KotlinCustomResource(javaResource, SqlPoolWorkloadGroupMapper) {
    /**
     * The workload group importance level.
     */
    public val importance: Output<String>?
        get() = javaResource.importance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload group cap percentage resource.
     */
    public val maxResourcePercent: Output<Int>
        get() = javaResource.maxResourcePercent().applyValue({ args0 -> args0 })

    /**
     * The workload group request maximum grant percentage.
     */
    public val maxResourcePercentPerRequest: Output<Double>?
        get() = javaResource.maxResourcePercentPerRequest().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The workload group minimum percentage resource.
     */
    public val minResourcePercent: Output<Int>
        get() = javaResource.minResourcePercent().applyValue({ args0 -> args0 })

    /**
     * The workload group request minimum grant percentage.
     */
    public val minResourcePercentPerRequest: Output<Double>
        get() = javaResource.minResourcePercentPerRequest().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The workload group query execution timeout.
     */
    public val queryExecutionTimeout: Output<Int>?
        get() = javaResource.queryExecutionTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlPoolWorkloadGroupMapper : ResourceMapper<SqlPoolWorkloadGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup::class == javaResource::class

    override fun map(javaResource: Resource): SqlPoolWorkloadGroup = SqlPoolWorkloadGroup(
        javaResource
            as com.pulumi.azurenative.synapse.SqlPoolWorkloadGroup,
    )
}

/**
 * @see [SqlPoolWorkloadGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlPoolWorkloadGroup].
 */
public suspend fun sqlPoolWorkloadGroup(
    name: String,
    block: suspend SqlPoolWorkloadGroupResourceBuilder.() -> Unit,
): SqlPoolWorkloadGroup {
    val builder = SqlPoolWorkloadGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlPoolWorkloadGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlPoolWorkloadGroup(name: String): SqlPoolWorkloadGroup {
    val builder = SqlPoolWorkloadGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
