@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.SynapseFunctions.getBigDataPoolPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getDatabasePrincipalAssignmentPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getEventGridDataConnectionPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getEventHubDataConnectionPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIntegrationRuntimeConnectionInfoPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIntegrationRuntimeObjectMetadatumPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIntegrationRuntimePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIntegrationRuntimeStatusPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIotHubDataConnectionPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getIpFirewallRulePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getKeyPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getKustoPoolAttachedDatabaseConfigurationPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getKustoPoolDatabasePrincipalAssignmentPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getKustoPoolPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getKustoPoolPrincipalAssignmentPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getPrivateLinkHubPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getReadOnlyFollowingDatabasePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getReadWriteDatabasePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolSensitivityLabelPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolTransparentDataEncryptionPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolVulnerabilityAssessmentPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolVulnerabilityAssessmentRuleBaselinePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolWorkloadClassifierPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getSqlPoolWorkloadGroupPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getWorkspaceAadAdminPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getWorkspaceManagedSqlServerVulnerabilityAssessmentPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getWorkspacePlain
import com.pulumi.azurenative.synapse.SynapseFunctions.getWorkspaceSqlAadAdminPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.listIntegrationRuntimeAuthKeyPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.listKustoPoolFollowerDatabasesPlain
import com.pulumi.azurenative.synapse.SynapseFunctions.listKustoPoolLanguageExtensionsPlain
import com.pulumi.azurenative.synapse.kotlin.inputs.GetBigDataPoolPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetBigDataPoolPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetDatabasePrincipalAssignmentPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetDatabasePrincipalAssignmentPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetEventGridDataConnectionPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetEventGridDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetEventHubDataConnectionPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetEventHubDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeConnectionInfoPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeStatusPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIntegrationRuntimeStatusPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIotHubDataConnectionPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIotHubDataConnectionPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIpFirewallRulePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetIpFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKeyPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKeyPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolAttachedDatabaseConfigurationPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolDatabasePrincipalAssignmentPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolPrincipalAssignmentPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetKustoPoolPrincipalAssignmentPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetPrivateLinkHubPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetPrivateLinkHubPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetReadOnlyFollowingDatabasePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetReadOnlyFollowingDatabasePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetReadWriteDatabasePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetReadWriteDatabasePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolSensitivityLabelPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolSensitivityLabelPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolTransparentDataEncryptionPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolTransparentDataEncryptionPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolWorkloadClassifierPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolWorkloadClassifierPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolWorkloadGroupPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetSqlPoolWorkloadGroupPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceAadAdminPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceAadAdminPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceSqlAadAdminPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.GetWorkspaceSqlAadAdminPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.ListIntegrationRuntimeAuthKeyPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.ListIntegrationRuntimeAuthKeyPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.ListKustoPoolFollowerDatabasesPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.ListKustoPoolFollowerDatabasesPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.inputs.ListKustoPoolLanguageExtensionsPlainArgs
import com.pulumi.azurenative.synapse.kotlin.inputs.ListKustoPoolLanguageExtensionsPlainArgsBuilder
import com.pulumi.azurenative.synapse.kotlin.outputs.GetBigDataPoolResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetDatabasePrincipalAssignmentResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetEventGridDataConnectionResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetEventHubDataConnectionResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeConnectionInfoResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeObjectMetadatumResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeStatusResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIotHubDataConnectionResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIpFirewallRuleResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKeyResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolAttachedDatabaseConfigurationResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolDatabasePrincipalAssignmentResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolPrincipalAssignmentResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetPrivateLinkHubResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetReadOnlyFollowingDatabaseResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetReadWriteDatabaseResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolSensitivityLabelResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolTransparentDataEncryptionResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolVulnerabilityAssessmentResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolVulnerabilityAssessmentRuleBaselineResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolWorkloadClassifierResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolWorkloadGroupResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceAadAdminResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceSqlAadAdminResult
import com.pulumi.azurenative.synapse.kotlin.outputs.ListIntegrationRuntimeAuthKeyResult
import com.pulumi.azurenative.synapse.kotlin.outputs.ListKustoPoolFollowerDatabasesResult
import com.pulumi.azurenative.synapse.kotlin.outputs.ListKustoPoolLanguageExtensionsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.synapse.kotlin.outputs.GetBigDataPoolResult.Companion.toKotlin as getBigDataPoolResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetDatabasePrincipalAssignmentResult.Companion.toKotlin as getDatabasePrincipalAssignmentResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetEventGridDataConnectionResult.Companion.toKotlin as getEventGridDataConnectionResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetEventHubDataConnectionResult.Companion.toKotlin as getEventHubDataConnectionResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeConnectionInfoResult.Companion.toKotlin as getIntegrationRuntimeConnectionInfoResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeObjectMetadatumResult.Companion.toKotlin as getIntegrationRuntimeObjectMetadatumResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeResult.Companion.toKotlin as getIntegrationRuntimeResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIntegrationRuntimeStatusResult.Companion.toKotlin as getIntegrationRuntimeStatusResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIotHubDataConnectionResult.Companion.toKotlin as getIotHubDataConnectionResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetIpFirewallRuleResult.Companion.toKotlin as getIpFirewallRuleResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKeyResult.Companion.toKotlin as getKeyResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolAttachedDatabaseConfigurationResult.Companion.toKotlin as getKustoPoolAttachedDatabaseConfigurationResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolDatabasePrincipalAssignmentResult.Companion.toKotlin as getKustoPoolDatabasePrincipalAssignmentResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolPrincipalAssignmentResult.Companion.toKotlin as getKustoPoolPrincipalAssignmentResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetKustoPoolResult.Companion.toKotlin as getKustoPoolResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetPrivateLinkHubResult.Companion.toKotlin as getPrivateLinkHubResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetReadOnlyFollowingDatabaseResult.Companion.toKotlin as getReadOnlyFollowingDatabaseResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetReadWriteDatabaseResult.Companion.toKotlin as getReadWriteDatabaseResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolResult.Companion.toKotlin as getSqlPoolResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolSensitivityLabelResult.Companion.toKotlin as getSqlPoolSensitivityLabelResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolTransparentDataEncryptionResult.Companion.toKotlin as getSqlPoolTransparentDataEncryptionResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolVulnerabilityAssessmentResult.Companion.toKotlin as getSqlPoolVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolVulnerabilityAssessmentRuleBaselineResult.Companion.toKotlin as getSqlPoolVulnerabilityAssessmentRuleBaselineResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolWorkloadClassifierResult.Companion.toKotlin as getSqlPoolWorkloadClassifierResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetSqlPoolWorkloadGroupResult.Companion.toKotlin as getSqlPoolWorkloadGroupResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceAadAdminResult.Companion.toKotlin as getWorkspaceAadAdminResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult.Companion.toKotlin as getWorkspaceManagedSqlServerVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.GetWorkspaceSqlAadAdminResult.Companion.toKotlin as getWorkspaceSqlAadAdminResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.ListIntegrationRuntimeAuthKeyResult.Companion.toKotlin as listIntegrationRuntimeAuthKeyResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.ListKustoPoolFollowerDatabasesResult.Companion.toKotlin as listKustoPoolFollowerDatabasesResultToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.ListKustoPoolLanguageExtensionsResult.Companion.toKotlin as listKustoPoolLanguageExtensionsResultToKotlin

public object SynapseFunctions {
    /**
     * Get a Big Data pool.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-05-01, 2021-06-01-preview.
     * @param argument null
     * @return A Big Data pool
     */
    public suspend fun getBigDataPool(argument: GetBigDataPoolPlainArgs): GetBigDataPoolResult =
        getBigDataPoolResultToKotlin(getBigDataPoolPlain(argument.toJava()).await())

    /**
     * @see [getBigDataPool].
     * @param bigDataPoolName Big Data pool name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return A Big Data pool
     */
    public suspend fun getBigDataPool(
        bigDataPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetBigDataPoolResult {
        val argument = GetBigDataPoolPlainArgs(
            bigDataPoolName = bigDataPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getBigDataPoolResultToKotlin(getBigDataPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getBigDataPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetBigDataPoolPlainArgs].
     * @return A Big Data pool
     */
    public suspend fun getBigDataPool(argument: suspend GetBigDataPoolPlainArgsBuilder.() -> Unit): GetBigDataPoolResult {
        val builder = GetBigDataPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBigDataPoolResultToKotlin(getBigDataPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto pool database principalAssignment.
     * Azure REST API version: 2021-04-01-preview.
     * @param argument null
     * @return Class representing a database principal assignment.
     */
    public suspend fun getDatabasePrincipalAssignment(argument: GetDatabasePrincipalAssignmentPlainArgs): GetDatabasePrincipalAssignmentResult =
        getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getDatabasePrincipalAssignment].
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param principalAssignmentName The name of the Kusto principalAssignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace
     * @return Class representing a database principal assignment.
     */
    public suspend fun getDatabasePrincipalAssignment(
        databaseName: String,
        kustoPoolName: String,
        principalAssignmentName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDatabasePrincipalAssignmentResult {
        val argument = GetDatabasePrincipalAssignmentPlainArgs(
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            principalAssignmentName = principalAssignmentName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabasePrincipalAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetDatabasePrincipalAssignmentPlainArgs].
     * @return Class representing a database principal assignment.
     */
    public suspend fun getDatabasePrincipalAssignment(argument: suspend GetDatabasePrincipalAssignmentPlainArgsBuilder.() -> Unit): GetDatabasePrincipalAssignmentResult {
        val builder = GetDatabasePrincipalAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabasePrincipalAssignmentResultToKotlin(getDatabasePrincipalAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing an Event Grid data connection.
     */
    public suspend fun getEventGridDataConnection(argument: GetEventGridDataConnectionPlainArgs): GetEventGridDataConnectionResult =
        getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventGridDataConnection].
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing an Event Grid data connection.
     */
    public suspend fun getEventGridDataConnection(
        dataConnectionName: String,
        databaseName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetEventGridDataConnectionResult {
        val argument = GetEventGridDataConnectionPlainArgs(
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventGridDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetEventGridDataConnectionPlainArgs].
     * @return Class representing an Event Grid data connection.
     */
    public suspend fun getEventGridDataConnection(argument: suspend GetEventGridDataConnectionPlainArgsBuilder.() -> Unit): GetEventGridDataConnectionResult {
        val builder = GetEventGridDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventGridDataConnectionResultToKotlin(getEventGridDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing an event hub data connection.
     */
    public suspend fun getEventHubDataConnection(argument: GetEventHubDataConnectionPlainArgs): GetEventHubDataConnectionResult =
        getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getEventHubDataConnection].
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing an event hub data connection.
     */
    public suspend fun getEventHubDataConnection(
        dataConnectionName: String,
        databaseName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetEventHubDataConnectionResult {
        val argument = GetEventHubDataConnectionPlainArgs(
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventHubDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetEventHubDataConnectionPlainArgs].
     * @return Class representing an event hub data connection.
     */
    public suspend fun getEventHubDataConnection(argument: suspend GetEventHubDataConnectionPlainArgsBuilder.() -> Unit): GetEventHubDataConnectionResult {
        val builder = GetEventHubDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventHubDataConnectionResultToKotlin(getEventHubDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an integration runtime
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Integration runtime resource type.
     */
    public suspend fun getIntegrationRuntime(argument: GetIntegrationRuntimePlainArgs): GetIntegrationRuntimeResult =
        getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntime].
     * @param integrationRuntimeName Integration runtime name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Integration runtime resource type.
     */
    public suspend fun getIntegrationRuntime(
        integrationRuntimeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIntegrationRuntimeResult {
        val argument = GetIntegrationRuntimePlainArgs(
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntime].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimePlainArgs].
     * @return Integration runtime resource type.
     */
    public suspend fun getIntegrationRuntime(argument: suspend GetIntegrationRuntimePlainArgsBuilder.() -> Unit): GetIntegrationRuntimeResult {
        val builder = GetIntegrationRuntimePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(builtArgument.toJava()).await())
    }

    /**
     * Get connection info for an integration runtime
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend fun getIntegrationRuntimeConnectionInfo(argument: GetIntegrationRuntimeConnectionInfoPlainArgs): GetIntegrationRuntimeConnectionInfoResult =
        getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeConnectionInfo].
     * @param integrationRuntimeName Integration runtime name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend fun getIntegrationRuntimeConnectionInfo(
        integrationRuntimeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIntegrationRuntimeConnectionInfoResult {
        val argument = GetIntegrationRuntimeConnectionInfoPlainArgs(
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeConnectionInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeConnectionInfoPlainArgs].
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend fun getIntegrationRuntimeConnectionInfo(argument: suspend GetIntegrationRuntimeConnectionInfoPlainArgsBuilder.() -> Unit): GetIntegrationRuntimeConnectionInfoResult {
        val builder = GetIntegrationRuntimeConnectionInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Get object metadata from an integration runtime
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A list of SSIS object metadata.
     */
    public suspend fun getIntegrationRuntimeObjectMetadatum(argument: GetIntegrationRuntimeObjectMetadatumPlainArgs): GetIntegrationRuntimeObjectMetadatumResult =
        getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeObjectMetadatum].
     * @param integrationRuntimeName Integration runtime name
     * @param metadataPath Metadata path.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return A list of SSIS object metadata.
     */
    public suspend fun getIntegrationRuntimeObjectMetadatum(
        integrationRuntimeName: String,
        metadataPath: String? = null,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIntegrationRuntimeObjectMetadatumResult {
        val argument = GetIntegrationRuntimeObjectMetadatumPlainArgs(
            integrationRuntimeName = integrationRuntimeName,
            metadataPath = metadataPath,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeObjectMetadatum].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeObjectMetadatumPlainArgs].
     * @return A list of SSIS object metadata.
     */
    public suspend fun getIntegrationRuntimeObjectMetadatum(argument: suspend GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder.() -> Unit): GetIntegrationRuntimeObjectMetadatumResult {
        val builder = GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the integration runtime status
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Integration runtime status response.
     */
    public suspend fun getIntegrationRuntimeStatus(argument: GetIntegrationRuntimeStatusPlainArgs): GetIntegrationRuntimeStatusResult =
        getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeStatus].
     * @param integrationRuntimeName Integration runtime name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Integration runtime status response.
     */
    public suspend fun getIntegrationRuntimeStatus(
        integrationRuntimeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIntegrationRuntimeStatusResult {
        val argument = GetIntegrationRuntimeStatusPlainArgs(
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeStatusPlainArgs].
     * @return Integration runtime status response.
     */
    public suspend fun getIntegrationRuntimeStatus(argument: suspend GetIntegrationRuntimeStatusPlainArgsBuilder.() -> Unit): GetIntegrationRuntimeStatusResult {
        val builder = GetIntegrationRuntimeStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a data connection.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing an iot hub data connection.
     */
    public suspend fun getIotHubDataConnection(argument: GetIotHubDataConnectionPlainArgs): GetIotHubDataConnectionResult =
        getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(argument.toJava()).await())

    /**
     * @see [getIotHubDataConnection].
     * @param dataConnectionName The name of the data connection.
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing an iot hub data connection.
     */
    public suspend fun getIotHubDataConnection(
        dataConnectionName: String,
        databaseName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetIotHubDataConnectionResult {
        val argument = GetIotHubDataConnectionPlainArgs(
            dataConnectionName = dataConnectionName,
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getIotHubDataConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIotHubDataConnectionPlainArgs].
     * @return Class representing an iot hub data connection.
     */
    public suspend fun getIotHubDataConnection(argument: suspend GetIotHubDataConnectionPlainArgsBuilder.() -> Unit): GetIotHubDataConnectionResult {
        val builder = GetIotHubDataConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIotHubDataConnectionResultToKotlin(getIotHubDataConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a firewall rule
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return IP firewall rule
     */
    public suspend fun getIpFirewallRule(argument: GetIpFirewallRulePlainArgs): GetIpFirewallRuleResult =
        getIpFirewallRuleResultToKotlin(getIpFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getIpFirewallRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleName The IP firewall rule name
     * @param workspaceName The name of the workspace.
     * @return IP firewall rule
     */
    public suspend fun getIpFirewallRule(
        resourceGroupName: String,
        ruleName: String,
        workspaceName: String,
    ): GetIpFirewallRuleResult {
        val argument = GetIpFirewallRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
            workspaceName = workspaceName,
        )
        return getIpFirewallRuleResultToKotlin(getIpFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getIpFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetIpFirewallRulePlainArgs].
     * @return IP firewall rule
     */
    public suspend fun getIpFirewallRule(argument: suspend GetIpFirewallRulePlainArgsBuilder.() -> Unit): GetIpFirewallRuleResult {
        val builder = GetIpFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpFirewallRuleResultToKotlin(getIpFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace key
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A workspace key
     */
    public suspend fun getKey(argument: GetKeyPlainArgs): GetKeyResult =
        getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())

    /**
     * @see [getKey].
     * @param keyName The name of the workspace key
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return A workspace key
     */
    public suspend fun getKey(
        keyName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetKeyResult {
        val argument = GetKeyPlainArgs(
            keyName = keyName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetKeyPlainArgs].
     * @return A workspace key
     */
    public suspend fun getKey(argument: suspend GetKeyPlainArgsBuilder.() -> Unit): GetKeyResult {
        val builder = GetKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyResultToKotlin(getKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto pool.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing a Kusto kusto pool.
     */
    public suspend fun getKustoPool(argument: GetKustoPoolPlainArgs): GetKustoPoolResult =
        getKustoPoolResultToKotlin(getKustoPoolPlain(argument.toJava()).await())

    /**
     * @see [getKustoPool].
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing a Kusto kusto pool.
     */
    public suspend fun getKustoPool(
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetKustoPoolResult {
        val argument = GetKustoPoolPlainArgs(
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getKustoPoolResultToKotlin(getKustoPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetKustoPoolPlainArgs].
     * @return Class representing a Kusto kusto pool.
     */
    public suspend fun getKustoPool(argument: suspend GetKustoPoolPlainArgsBuilder.() -> Unit): GetKustoPoolResult {
        val builder = GetKustoPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoPoolResultToKotlin(getKustoPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns an attached database configuration.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing an attached database configuration.
     */
    public suspend fun getKustoPoolAttachedDatabaseConfiguration(argument: GetKustoPoolAttachedDatabaseConfigurationPlainArgs): GetKustoPoolAttachedDatabaseConfigurationResult =
        getKustoPoolAttachedDatabaseConfigurationResultToKotlin(getKustoPoolAttachedDatabaseConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getKustoPoolAttachedDatabaseConfiguration].
     * @param attachedDatabaseConfigurationName The name of the attached database configuration.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing an attached database configuration.
     */
    public suspend fun getKustoPoolAttachedDatabaseConfiguration(
        attachedDatabaseConfigurationName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetKustoPoolAttachedDatabaseConfigurationResult {
        val argument = GetKustoPoolAttachedDatabaseConfigurationPlainArgs(
            attachedDatabaseConfigurationName = attachedDatabaseConfigurationName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getKustoPoolAttachedDatabaseConfigurationResultToKotlin(getKustoPoolAttachedDatabaseConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoPoolAttachedDatabaseConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetKustoPoolAttachedDatabaseConfigurationPlainArgs].
     * @return Class representing an attached database configuration.
     */
    public suspend fun getKustoPoolAttachedDatabaseConfiguration(argument: suspend GetKustoPoolAttachedDatabaseConfigurationPlainArgsBuilder.() -> Unit): GetKustoPoolAttachedDatabaseConfigurationResult {
        val builder = GetKustoPoolAttachedDatabaseConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoPoolAttachedDatabaseConfigurationResultToKotlin(getKustoPoolAttachedDatabaseConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto pool database principalAssignment.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing a database principal assignment.
     */
    public suspend fun getKustoPoolDatabasePrincipalAssignment(argument: GetKustoPoolDatabasePrincipalAssignmentPlainArgs): GetKustoPoolDatabasePrincipalAssignmentResult =
        getKustoPoolDatabasePrincipalAssignmentResultToKotlin(getKustoPoolDatabasePrincipalAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getKustoPoolDatabasePrincipalAssignment].
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param principalAssignmentName The name of the Kusto principalAssignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing a database principal assignment.
     */
    public suspend fun getKustoPoolDatabasePrincipalAssignment(
        databaseName: String,
        kustoPoolName: String,
        principalAssignmentName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetKustoPoolDatabasePrincipalAssignmentResult {
        val argument = GetKustoPoolDatabasePrincipalAssignmentPlainArgs(
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            principalAssignmentName = principalAssignmentName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getKustoPoolDatabasePrincipalAssignmentResultToKotlin(getKustoPoolDatabasePrincipalAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoPoolDatabasePrincipalAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetKustoPoolDatabasePrincipalAssignmentPlainArgs].
     * @return Class representing a database principal assignment.
     */
    public suspend fun getKustoPoolDatabasePrincipalAssignment(argument: suspend GetKustoPoolDatabasePrincipalAssignmentPlainArgsBuilder.() -> Unit): GetKustoPoolDatabasePrincipalAssignmentResult {
        val builder = GetKustoPoolDatabasePrincipalAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoPoolDatabasePrincipalAssignmentResultToKotlin(getKustoPoolDatabasePrincipalAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Kusto pool principalAssignment.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing a cluster principal assignment.
     */
    public suspend fun getKustoPoolPrincipalAssignment(argument: GetKustoPoolPrincipalAssignmentPlainArgs): GetKustoPoolPrincipalAssignmentResult =
        getKustoPoolPrincipalAssignmentResultToKotlin(getKustoPoolPrincipalAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getKustoPoolPrincipalAssignment].
     * @param kustoPoolName The name of the Kusto pool.
     * @param principalAssignmentName The name of the Kusto principalAssignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing a cluster principal assignment.
     */
    public suspend fun getKustoPoolPrincipalAssignment(
        kustoPoolName: String,
        principalAssignmentName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetKustoPoolPrincipalAssignmentResult {
        val argument = GetKustoPoolPrincipalAssignmentPlainArgs(
            kustoPoolName = kustoPoolName,
            principalAssignmentName = principalAssignmentName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getKustoPoolPrincipalAssignmentResultToKotlin(getKustoPoolPrincipalAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getKustoPoolPrincipalAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetKustoPoolPrincipalAssignmentPlainArgs].
     * @return Class representing a cluster principal assignment.
     */
    public suspend fun getKustoPoolPrincipalAssignment(argument: suspend GetKustoPoolPrincipalAssignmentPlainArgsBuilder.() -> Unit): GetKustoPoolPrincipalAssignmentResult {
        val builder = GetKustoPoolPrincipalAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKustoPoolPrincipalAssignmentResultToKotlin(getKustoPoolPrincipalAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a privateLinkHub
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A privateLinkHub
     */
    public suspend fun getPrivateLinkHub(argument: GetPrivateLinkHubPlainArgs): GetPrivateLinkHubResult =
        getPrivateLinkHubResultToKotlin(getPrivateLinkHubPlain(argument.toJava()).await())

    /**
     * @see [getPrivateLinkHub].
     * @param privateLinkHubName Name of the privateLinkHub
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A privateLinkHub
     */
    public suspend fun getPrivateLinkHub(privateLinkHubName: String, resourceGroupName: String): GetPrivateLinkHubResult {
        val argument = GetPrivateLinkHubPlainArgs(
            privateLinkHubName = privateLinkHubName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateLinkHubResultToKotlin(getPrivateLinkHubPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateLinkHub].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetPrivateLinkHubPlainArgs].
     * @return A privateLinkHub
     */
    public suspend fun getPrivateLinkHub(argument: suspend GetPrivateLinkHubPlainArgsBuilder.() -> Unit): GetPrivateLinkHubResult {
        val builder = GetPrivateLinkHubPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateLinkHubResultToKotlin(getPrivateLinkHubPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a database.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing a read only following database.
     */
    public suspend fun getReadOnlyFollowingDatabase(argument: GetReadOnlyFollowingDatabasePlainArgs): GetReadOnlyFollowingDatabaseResult =
        getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(argument.toJava()).await())

    /**
     * @see [getReadOnlyFollowingDatabase].
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing a read only following database.
     */
    public suspend fun getReadOnlyFollowingDatabase(
        databaseName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetReadOnlyFollowingDatabaseResult {
        val argument = GetReadOnlyFollowingDatabasePlainArgs(
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getReadOnlyFollowingDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetReadOnlyFollowingDatabasePlainArgs].
     * @return Class representing a read only following database.
     */
    public suspend fun getReadOnlyFollowingDatabase(argument: suspend GetReadOnlyFollowingDatabasePlainArgsBuilder.() -> Unit): GetReadOnlyFollowingDatabaseResult {
        val builder = GetReadOnlyFollowingDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReadOnlyFollowingDatabaseResultToKotlin(getReadOnlyFollowingDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a database.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return Class representing a read write database.
     */
    public suspend fun getReadWriteDatabase(argument: GetReadWriteDatabasePlainArgs): GetReadWriteDatabaseResult =
        getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(argument.toJava()).await())

    /**
     * @see [getReadWriteDatabase].
     * @param databaseName The name of the database in the Kusto pool.
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Class representing a read write database.
     */
    public suspend fun getReadWriteDatabase(
        databaseName: String,
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetReadWriteDatabaseResult {
        val argument = GetReadWriteDatabasePlainArgs(
            databaseName = databaseName,
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getReadWriteDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetReadWriteDatabasePlainArgs].
     * @return Class representing a read write database.
     */
    public suspend fun getReadWriteDatabase(argument: suspend GetReadWriteDatabasePlainArgsBuilder.() -> Unit): GetReadWriteDatabaseResult {
        val builder = GetReadWriteDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReadWriteDatabaseResultToKotlin(getReadWriteDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Get SQL pool properties
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-05-01, 2021-06-01-preview.
     * @param argument null
     * @return A SQL Analytics pool
     */
    public suspend fun getSqlPool(argument: GetSqlPoolPlainArgs): GetSqlPoolResult =
        getSqlPoolResultToKotlin(getSqlPoolPlain(argument.toJava()).await())

    /**
     * @see [getSqlPool].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sqlPoolName SQL pool name
     * @param workspaceName The name of the workspace.
     * @return A SQL Analytics pool
     */
    public suspend fun getSqlPool(
        resourceGroupName: String,
        sqlPoolName: String,
        workspaceName: String,
    ): GetSqlPoolResult {
        val argument = GetSqlPoolPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlPoolName = sqlPoolName,
            workspaceName = workspaceName,
        )
        return getSqlPoolResultToKotlin(getSqlPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolPlainArgs].
     * @return A SQL Analytics pool
     */
    public suspend fun getSqlPool(argument: suspend GetSqlPoolPlainArgsBuilder.() -> Unit): GetSqlPoolResult {
        val builder = GetSqlPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolResultToKotlin(getSqlPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sensitivity label of a given column
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A sensitivity label.
     */
    public suspend fun getSqlPoolSensitivityLabel(argument: GetSqlPoolSensitivityLabelPlainArgs): GetSqlPoolSensitivityLabelResult =
        getSqlPoolSensitivityLabelResultToKotlin(getSqlPoolSensitivityLabelPlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolSensitivityLabel].
     * @param columnName The name of the column.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param schemaName The name of the schema.
     * @param sensitivityLabelSource The source of the sensitivity label.
     * @param sqlPoolName SQL pool name
     * @param tableName The name of the table.
     * @param workspaceName The name of the workspace.
     * @return A sensitivity label.
     */
    public suspend fun getSqlPoolSensitivityLabel(
        columnName: String,
        resourceGroupName: String,
        schemaName: String,
        sensitivityLabelSource: String,
        sqlPoolName: String,
        tableName: String,
        workspaceName: String,
    ): GetSqlPoolSensitivityLabelResult {
        val argument = GetSqlPoolSensitivityLabelPlainArgs(
            columnName = columnName,
            resourceGroupName = resourceGroupName,
            schemaName = schemaName,
            sensitivityLabelSource = sensitivityLabelSource,
            sqlPoolName = sqlPoolName,
            tableName = tableName,
            workspaceName = workspaceName,
        )
        return getSqlPoolSensitivityLabelResultToKotlin(getSqlPoolSensitivityLabelPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolSensitivityLabel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolSensitivityLabelPlainArgs].
     * @return A sensitivity label.
     */
    public suspend fun getSqlPoolSensitivityLabel(argument: suspend GetSqlPoolSensitivityLabelPlainArgsBuilder.() -> Unit): GetSqlPoolSensitivityLabelResult {
        val builder = GetSqlPoolSensitivityLabelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolSensitivityLabelResultToKotlin(getSqlPoolSensitivityLabelPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SQL pool's transparent data encryption configuration.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Represents a Sql pool transparent data encryption configuration.
     */
    public suspend fun getSqlPoolTransparentDataEncryption(argument: GetSqlPoolTransparentDataEncryptionPlainArgs): GetSqlPoolTransparentDataEncryptionResult =
        getSqlPoolTransparentDataEncryptionResultToKotlin(getSqlPoolTransparentDataEncryptionPlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolTransparentDataEncryption].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sqlPoolName SQL pool name
     * @param transparentDataEncryptionName The name of the transparent data encryption configuration.
     * @param workspaceName The name of the workspace.
     * @return Represents a Sql pool transparent data encryption configuration.
     */
    public suspend fun getSqlPoolTransparentDataEncryption(
        resourceGroupName: String,
        sqlPoolName: String,
        transparentDataEncryptionName: String,
        workspaceName: String,
    ): GetSqlPoolTransparentDataEncryptionResult {
        val argument = GetSqlPoolTransparentDataEncryptionPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlPoolName = sqlPoolName,
            transparentDataEncryptionName = transparentDataEncryptionName,
            workspaceName = workspaceName,
        )
        return getSqlPoolTransparentDataEncryptionResultToKotlin(getSqlPoolTransparentDataEncryptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolTransparentDataEncryption].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolTransparentDataEncryptionPlainArgs].
     * @return Represents a Sql pool transparent data encryption configuration.
     */
    public suspend fun getSqlPoolTransparentDataEncryption(argument: suspend GetSqlPoolTransparentDataEncryptionPlainArgsBuilder.() -> Unit): GetSqlPoolTransparentDataEncryptionResult {
        val builder = GetSqlPoolTransparentDataEncryptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolTransparentDataEncryptionResultToKotlin(getSqlPoolTransparentDataEncryptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Sql pool's vulnerability assessment.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A Sql pool vulnerability assessment.
     */
    public suspend fun getSqlPoolVulnerabilityAssessment(argument: GetSqlPoolVulnerabilityAssessmentPlainArgs): GetSqlPoolVulnerabilityAssessmentResult =
        getSqlPoolVulnerabilityAssessmentResultToKotlin(getSqlPoolVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolVulnerabilityAssessment].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sqlPoolName SQL pool name
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param workspaceName The name of the workspace.
     * @return A Sql pool vulnerability assessment.
     */
    public suspend fun getSqlPoolVulnerabilityAssessment(
        resourceGroupName: String,
        sqlPoolName: String,
        vulnerabilityAssessmentName: String,
        workspaceName: String,
    ): GetSqlPoolVulnerabilityAssessmentResult {
        val argument = GetSqlPoolVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlPoolName = sqlPoolName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
            workspaceName = workspaceName,
        )
        return getSqlPoolVulnerabilityAssessmentResultToKotlin(getSqlPoolVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolVulnerabilityAssessmentPlainArgs].
     * @return A Sql pool vulnerability assessment.
     */
    public suspend fun getSqlPoolVulnerabilityAssessment(argument: suspend GetSqlPoolVulnerabilityAssessmentPlainArgsBuilder.() -> Unit): GetSqlPoolVulnerabilityAssessmentResult {
        val builder = GetSqlPoolVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolVulnerabilityAssessmentResultToKotlin(getSqlPoolVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a SqlPool's vulnerability assessment rule baseline.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A Sql pool vulnerability assessment rule baseline.
     */
    public suspend fun getSqlPoolVulnerabilityAssessmentRuleBaseline(argument: GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs): GetSqlPoolVulnerabilityAssessmentRuleBaselineResult =
        getSqlPoolVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlPoolVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolVulnerabilityAssessmentRuleBaseline].
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule).
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleId The vulnerability assessment rule ID.
     * @param sqlPoolName SQL pool name
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param workspaceName The name of the workspace.
     * @return A Sql pool vulnerability assessment rule baseline.
     */
    public suspend fun getSqlPoolVulnerabilityAssessmentRuleBaseline(
        baselineName: String,
        resourceGroupName: String,
        ruleId: String,
        sqlPoolName: String,
        vulnerabilityAssessmentName: String,
        workspaceName: String,
    ): GetSqlPoolVulnerabilityAssessmentRuleBaselineResult {
        val argument = GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            sqlPoolName = sqlPoolName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
            workspaceName = workspaceName,
        )
        return getSqlPoolVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlPoolVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolVulnerabilityAssessmentRuleBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgs].
     * @return A Sql pool vulnerability assessment rule baseline.
     */
    public suspend fun getSqlPoolVulnerabilityAssessmentRuleBaseline(argument: suspend GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgsBuilder.() -> Unit): GetSqlPoolVulnerabilityAssessmentRuleBaselineResult {
        val builder = GetSqlPoolVulnerabilityAssessmentRuleBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlPoolVulnerabilityAssessmentRuleBaselinePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a workload classifier of Sql pool's workload group.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Workload classifier operations for a data warehouse
     */
    public suspend fun getSqlPoolWorkloadClassifier(argument: GetSqlPoolWorkloadClassifierPlainArgs): GetSqlPoolWorkloadClassifierResult =
        getSqlPoolWorkloadClassifierResultToKotlin(getSqlPoolWorkloadClassifierPlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolWorkloadClassifier].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sqlPoolName SQL pool name
     * @param workloadClassifierName The name of the workload classifier.
     * @param workloadGroupName The name of the workload group.
     * @param workspaceName The name of the workspace.
     * @return Workload classifier operations for a data warehouse
     */
    public suspend fun getSqlPoolWorkloadClassifier(
        resourceGroupName: String,
        sqlPoolName: String,
        workloadClassifierName: String,
        workloadGroupName: String,
        workspaceName: String,
    ): GetSqlPoolWorkloadClassifierResult {
        val argument = GetSqlPoolWorkloadClassifierPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlPoolName = sqlPoolName,
            workloadClassifierName = workloadClassifierName,
            workloadGroupName = workloadGroupName,
            workspaceName = workspaceName,
        )
        return getSqlPoolWorkloadClassifierResultToKotlin(getSqlPoolWorkloadClassifierPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolWorkloadClassifier].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolWorkloadClassifierPlainArgs].
     * @return Workload classifier operations for a data warehouse
     */
    public suspend fun getSqlPoolWorkloadClassifier(argument: suspend GetSqlPoolWorkloadClassifierPlainArgsBuilder.() -> Unit): GetSqlPoolWorkloadClassifierResult {
        val builder = GetSqlPoolWorkloadClassifierPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolWorkloadClassifierResultToKotlin(getSqlPoolWorkloadClassifierPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Sql pool's workload group.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Workload group operations for a sql pool
     */
    public suspend fun getSqlPoolWorkloadGroup(argument: GetSqlPoolWorkloadGroupPlainArgs): GetSqlPoolWorkloadGroupResult =
        getSqlPoolWorkloadGroupResultToKotlin(getSqlPoolWorkloadGroupPlain(argument.toJava()).await())

    /**
     * @see [getSqlPoolWorkloadGroup].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param sqlPoolName SQL pool name
     * @param workloadGroupName The name of the workload group.
     * @param workspaceName The name of the workspace.
     * @return Workload group operations for a sql pool
     */
    public suspend fun getSqlPoolWorkloadGroup(
        resourceGroupName: String,
        sqlPoolName: String,
        workloadGroupName: String,
        workspaceName: String,
    ): GetSqlPoolWorkloadGroupResult {
        val argument = GetSqlPoolWorkloadGroupPlainArgs(
            resourceGroupName = resourceGroupName,
            sqlPoolName = sqlPoolName,
            workloadGroupName = workloadGroupName,
            workspaceName = workspaceName,
        )
        return getSqlPoolWorkloadGroupResultToKotlin(getSqlPoolWorkloadGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlPoolWorkloadGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetSqlPoolWorkloadGroupPlainArgs].
     * @return Workload group operations for a sql pool
     */
    public suspend fun getSqlPoolWorkloadGroup(argument: suspend GetSqlPoolWorkloadGroupPlainArgsBuilder.() -> Unit): GetSqlPoolWorkloadGroupResult {
        val builder = GetSqlPoolWorkloadGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlPoolWorkloadGroupResultToKotlin(getSqlPoolWorkloadGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-05-01, 2021-06-01-preview.
     * @param argument null
     * @return A workspace
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return A workspace
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return A workspace
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit): GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace active directory admin
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceAadAdmin(argument: GetWorkspaceAadAdminPlainArgs): GetWorkspaceAadAdminResult =
        getWorkspaceAadAdminResultToKotlin(getWorkspaceAadAdminPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceAadAdmin].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceAadAdmin(resourceGroupName: String, workspaceName: String): GetWorkspaceAadAdminResult {
        val argument = GetWorkspaceAadAdminPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceAadAdminResultToKotlin(getWorkspaceAadAdminPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceAadAdmin].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetWorkspaceAadAdminPlainArgs].
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceAadAdmin(argument: suspend GetWorkspaceAadAdminPlainArgsBuilder.() -> Unit): GetWorkspaceAadAdminResult {
        val builder = GetWorkspaceAadAdminPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceAadAdminResultToKotlin(getWorkspaceAadAdminPlain(builtArgument.toJava()).await())
    }

    /**
     * Get workspace managed sql server's vulnerability assessment.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return A server vulnerability assessment.
     */
    public suspend fun getWorkspaceManagedSqlServerVulnerabilityAssessment(argument: GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs): GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult =
        getWorkspaceManagedSqlServerVulnerabilityAssessmentResultToKotlin(getWorkspaceManagedSqlServerVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceManagedSqlServerVulnerabilityAssessment].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @param workspaceName The name of the workspace.
     * @return A server vulnerability assessment.
     */
    public suspend fun getWorkspaceManagedSqlServerVulnerabilityAssessment(
        resourceGroupName: String,
        vulnerabilityAssessmentName: String,
        workspaceName: String,
    ): GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult {
        val argument = GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
            workspaceName = workspaceName,
        )
        return getWorkspaceManagedSqlServerVulnerabilityAssessmentResultToKotlin(getWorkspaceManagedSqlServerVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceManagedSqlServerVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgs].
     * @return A server vulnerability assessment.
     */
    public suspend fun getWorkspaceManagedSqlServerVulnerabilityAssessment(argument: suspend GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgsBuilder.() -> Unit): GetWorkspaceManagedSqlServerVulnerabilityAssessmentResult {
        val builder = GetWorkspaceManagedSqlServerVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceManagedSqlServerVulnerabilityAssessmentResultToKotlin(getWorkspaceManagedSqlServerVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace SQL active directory admin
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceSqlAadAdmin(argument: GetWorkspaceSqlAadAdminPlainArgs): GetWorkspaceSqlAadAdminResult =
        getWorkspaceSqlAadAdminResultToKotlin(getWorkspaceSqlAadAdminPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceSqlAadAdmin].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceSqlAadAdmin(resourceGroupName: String, workspaceName: String): GetWorkspaceSqlAadAdminResult {
        val argument = GetWorkspaceSqlAadAdminPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceSqlAadAdminResultToKotlin(getWorkspaceSqlAadAdminPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceSqlAadAdmin].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;GetWorkspaceSqlAadAdminPlainArgs].
     * @return Workspace active directory administrator
     */
    public suspend fun getWorkspaceSqlAadAdmin(argument: suspend GetWorkspaceSqlAadAdminPlainArgsBuilder.() -> Unit): GetWorkspaceSqlAadAdminResult {
        val builder = GetWorkspaceSqlAadAdminPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceSqlAadAdminResultToKotlin(getWorkspaceSqlAadAdminPlain(builtArgument.toJava()).await())
    }

    /**
     * List authentication keys in an integration runtime
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2021-06-01-preview.
     * @param argument null
     * @return The integration runtime authentication keys.
     */
    public suspend fun listIntegrationRuntimeAuthKey(argument: ListIntegrationRuntimeAuthKeyPlainArgs): ListIntegrationRuntimeAuthKeyResult =
        listIntegrationRuntimeAuthKeyResultToKotlin(listIntegrationRuntimeAuthKeyPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationRuntimeAuthKey].
     * @param integrationRuntimeName Integration runtime name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The integration runtime authentication keys.
     */
    public suspend fun listIntegrationRuntimeAuthKey(
        integrationRuntimeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListIntegrationRuntimeAuthKeyResult {
        val argument = ListIntegrationRuntimeAuthKeyPlainArgs(
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listIntegrationRuntimeAuthKeyResultToKotlin(listIntegrationRuntimeAuthKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationRuntimeAuthKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;ListIntegrationRuntimeAuthKeyPlainArgs].
     * @return The integration runtime authentication keys.
     */
    public suspend fun listIntegrationRuntimeAuthKey(argument: suspend ListIntegrationRuntimeAuthKeyPlainArgsBuilder.() -> Unit): ListIntegrationRuntimeAuthKeyResult {
        val builder = ListIntegrationRuntimeAuthKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationRuntimeAuthKeyResultToKotlin(listIntegrationRuntimeAuthKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of databases that are owned by this Kusto Pool and were followed by another Kusto Pool.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listKustoPoolFollowerDatabases(argument: ListKustoPoolFollowerDatabasesPlainArgs): ListKustoPoolFollowerDatabasesResult =
        listKustoPoolFollowerDatabasesResultToKotlin(listKustoPoolFollowerDatabasesPlain(argument.toJava()).await())

    /**
     * @see [listKustoPoolFollowerDatabases].
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listKustoPoolFollowerDatabases(
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListKustoPoolFollowerDatabasesResult {
        val argument = ListKustoPoolFollowerDatabasesPlainArgs(
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listKustoPoolFollowerDatabasesResultToKotlin(listKustoPoolFollowerDatabasesPlain(argument.toJava()).await())
    }

    /**
     * @see [listKustoPoolFollowerDatabases].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;ListKustoPoolFollowerDatabasesPlainArgs].
     * @return The list Kusto database principals operation response.
     */
    public suspend fun listKustoPoolFollowerDatabases(argument: suspend ListKustoPoolFollowerDatabasesPlainArgsBuilder.() -> Unit): ListKustoPoolFollowerDatabasesResult {
        val builder = ListKustoPoolFollowerDatabasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listKustoPoolFollowerDatabasesResultToKotlin(listKustoPoolFollowerDatabasesPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of language extensions that can run within KQL queries.
     * Azure REST API version: 2021-06-01-preview.
     * @param argument null
     * @return The list of language extension objects.
     */
    public suspend fun listKustoPoolLanguageExtensions(argument: ListKustoPoolLanguageExtensionsPlainArgs): ListKustoPoolLanguageExtensionsResult =
        listKustoPoolLanguageExtensionsResultToKotlin(listKustoPoolLanguageExtensionsPlain(argument.toJava()).await())

    /**
     * @see [listKustoPoolLanguageExtensions].
     * @param kustoPoolName The name of the Kusto pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The list of language extension objects.
     */
    public suspend fun listKustoPoolLanguageExtensions(
        kustoPoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListKustoPoolLanguageExtensionsResult {
        val argument = ListKustoPoolLanguageExtensionsPlainArgs(
            kustoPoolName = kustoPoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listKustoPoolLanguageExtensionsResultToKotlin(listKustoPoolLanguageExtensionsPlain(argument.toJava()).await())
    }

    /**
     * @see [listKustoPoolLanguageExtensions].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;synapse&#46;kotlin&#46;inputs&#46;ListKustoPoolLanguageExtensionsPlainArgs].
     * @return The list of language extension objects.
     */
    public suspend fun listKustoPoolLanguageExtensions(argument: suspend ListKustoPoolLanguageExtensionsPlainArgsBuilder.() -> Unit): ListKustoPoolLanguageExtensionsResult {
        val builder = ListKustoPoolLanguageExtensionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listKustoPoolLanguageExtensionsResultToKotlin(listKustoPoolLanguageExtensionsPlain(builtArgument.toJava()).await())
    }
}
