@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.kotlin.outputs.CspWorkspaceAdminPropertiesResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.DataLakeStorageAccountDetailsResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.EncryptionDetailsResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIdentityResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.ManagedVirtualNetworkSettingsResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.PurviewConfigurationResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.VirtualNetworkProfileResponse
import com.pulumi.azurenative.synapse.kotlin.outputs.WorkspaceRepositoryConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.synapse.kotlin.outputs.CspWorkspaceAdminPropertiesResponse.Companion.toKotlin as cspWorkspaceAdminPropertiesResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.DataLakeStorageAccountDetailsResponse.Companion.toKotlin as dataLakeStorageAccountDetailsResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.EncryptionDetailsResponse.Companion.toKotlin as encryptionDetailsResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin as managedIdentityResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.ManagedVirtualNetworkSettingsResponse.Companion.toKotlin as managedVirtualNetworkSettingsResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.PurviewConfigurationResponse.Companion.toKotlin as purviewConfigurationResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.VirtualNetworkProfileResponse.Companion.toKotlin as virtualNetworkProfileResponseToKotlin
import com.pulumi.azurenative.synapse.kotlin.outputs.WorkspaceRepositoryConfigurationResponse.Companion.toKotlin as workspaceRepositoryConfigurationResponseToKotlin

/**
 * Builder for [Workspace].
 */
@PulumiTagMarker
public class WorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceArgs = WorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceArgsBuilder.() -> Unit) {
        val builder = WorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workspace {
        val builtJavaResource = com.pulumi.azurenative.synapse.Workspace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workspace(builtJavaResource)
    }
}

/**
 * A workspace
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-05-01, 2021-06-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:Workspace workspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}
 * ```
 */
public class Workspace internal constructor(
    override val javaResource: com.pulumi.azurenative.synapse.Workspace,
) : KotlinCustomResource(javaResource, WorkspaceMapper) {
    /**
     * The ADLA resource ID.
     */
    public val adlaResourceId: Output<String>
        get() = javaResource.adlaResourceId().applyValue({ args0 -> args0 })

    /**
     * Connectivity endpoints
     */
    public val connectivityEndpoints: Output<Map<String, String>>
        get() = javaResource.connectivityEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Initial workspace AAD admin properties for a CSP subscription
     */
    public val cspWorkspaceAdminProperties: Output<CspWorkspaceAdminPropertiesResponse>?
        get() = javaResource.cspWorkspaceAdminProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cspWorkspaceAdminPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Workspace default data lake storage account details
     */
    public val defaultDataLakeStorage: Output<DataLakeStorageAccountDetailsResponse>?
        get() = javaResource.defaultDataLakeStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataLakeStorageAccountDetailsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The encryption details of the workspace
     */
    public val encryption: Output<EncryptionDetailsResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionDetailsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Workspace level configs and feature flags
     */
    public val extraProperties: Output<Any>
        get() = javaResource.extraProperties().applyValue({ args0 -> args0 })

    /**
     * Identity of the workspace
     */
    public val identity: Output<ManagedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Workspace managed resource group. The resource group name uniquely identifies the resource group within the user subscriptionId. The resource group name must be no longer than 90 characters long, and must be alphanumeric characters (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'
     */
    public val managedResourceGroupName: Output<String>?
        get() = javaResource.managedResourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Setting this to 'default' will ensure that all compute for this workspace is in a virtual network managed on behalf of the user.
     */
    public val managedVirtualNetwork: Output<String>?
        get() = javaResource.managedVirtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Managed Virtual Network Settings
     */
    public val managedVirtualNetworkSettings: Output<ManagedVirtualNetworkSettingsResponse>?
        get() = javaResource.managedVirtualNetworkSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> managedVirtualNetworkSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint connections to the workspace
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource provisioning state
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Enable or Disable public network access to workspace
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purview Configuration
     */
    public val purviewConfiguration: Output<PurviewConfigurationResponse>?
        get() = javaResource.purviewConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> purviewConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Workspace settings
     */
    public val settings: Output<Map<String, Any>>
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Login for workspace SQL active directory administrator
     */
    public val sqlAdministratorLogin: Output<String>?
        get() = javaResource.sqlAdministratorLogin().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL administrator login password
     */
    public val sqlAdministratorLoginPassword: Output<String>?
        get() = javaResource.sqlAdministratorLoginPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Is trustedServiceBypassEnabled for the workspace
     */
    public val trustedServiceBypassEnabled: Output<Boolean>?
        get() = javaResource.trustedServiceBypassEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Virtual Network profile
     */
    public val virtualNetworkProfile: Output<VirtualNetworkProfileResponse>?
        get() = javaResource.virtualNetworkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> virtualNetworkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Git integration settings
     */
    public val workspaceRepositoryConfiguration: Output<WorkspaceRepositoryConfigurationResponse>?
        get() = javaResource.workspaceRepositoryConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    workspaceRepositoryConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The workspace unique identifier
     */
    public val workspaceUID: Output<String>
        get() = javaResource.workspaceUID().applyValue({ args0 -> args0 })
}

public object WorkspaceMapper : ResourceMapper<Workspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.synapse.Workspace::class == javaResource::class

    override fun map(javaResource: Resource): Workspace = Workspace(
        javaResource as
            com.pulumi.azurenative.synapse.Workspace,
    )
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workspace].
 */
public suspend fun workspace(name: String, block: suspend WorkspaceResourceBuilder.() -> Unit): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspace(name: String): Workspace {
    val builder = WorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
