@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin

import com.pulumi.azurenative.synapse.WorkspaceAadAdminArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workspace active directory administrator
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update workspace active directory admin
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceAadAdmin = new AzureNative.Synapse.WorkspaceAadAdmin("workspaceAadAdmin", new()
 *     {
 *         AdministratorType = "ActiveDirectory",
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "resourceGroup1",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/synapse/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synapse.NewWorkspaceAadAdmin(ctx, "workspaceAadAdmin", &synapse.WorkspaceAadAdminArgs{
 * 			AdministratorType: pulumi.String("ActiveDirectory"),
 * 			Login:             pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Sid:               pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:          pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.synapse.WorkspaceAadAdmin;
 * import com.pulumi.azurenative.synapse.WorkspaceAadAdminArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceAadAdmin = new WorkspaceAadAdmin("workspaceAadAdmin", WorkspaceAadAdminArgs.builder()
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("resourceGroup1")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:synapse:WorkspaceAadAdmin activeDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/administrators/activeDirectory
 * ```
 * @property administratorType Workspace active directory administrator type
 * @property login Login of the workspace active directory administrator
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sid Object ID of the workspace active directory administrator
 * @property tenantId Tenant ID of the workspace active directory administrator
 * @property workspaceName The name of the workspace.
 */
public data class WorkspaceAadAdminArgs(
    public val administratorType: Output<String>? = null,
    public val login: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.WorkspaceAadAdminArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.WorkspaceAadAdminArgs =
        com.pulumi.azurenative.synapse.WorkspaceAadAdminArgs.builder()
            .administratorType(administratorType?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceAadAdminArgs].
 */
@PulumiTagMarker
public class WorkspaceAadAdminArgsBuilder internal constructor() {
    private var administratorType: Output<String>? = null

    private var login: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sid: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Workspace active directory administrator type
     */
    @JvmName("qblksfgonoygohxs")
    public suspend fun administratorType(`value`: Output<String>) {
        this.administratorType = value
    }

    /**
     * @param value Login of the workspace active directory administrator
     */
    @JvmName("wnopxufnrnsnxeal")
    public suspend fun login(`value`: Output<String>) {
        this.login = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("itrgkkdftgotjagx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Object ID of the workspace active directory administrator
     */
    @JvmName("efeaujbrbbsfmvem")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Tenant ID of the workspace active directory administrator
     */
    @JvmName("pxfykevtymudprgv")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("iyfkqigjojcbrxjs")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Workspace active directory administrator type
     */
    @JvmName("dnlgiiooswvxxtwl")
    public suspend fun administratorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Login of the workspace active directory administrator
     */
    @JvmName("oabfqexefpmmpaun")
    public suspend fun login(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("stuitiitfhbimyyc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Object ID of the workspace active directory administrator
     */
    @JvmName("qjbqyjbtidfrtdvy")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Tenant ID of the workspace active directory administrator
     */
    @JvmName("agicvifeuvlkbjcn")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("itcidkouxfhiersp")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceAadAdminArgs = WorkspaceAadAdminArgs(
        administratorType = administratorType,
        login = login,
        resourceGroupName = resourceGroupName,
        sid = sid,
        tenantId = tenantId,
        workspaceName = workspaceName,
    )
}
