@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Compute type of the cluster which will execute data flow job.
 */
public enum class DataFlowComputeType(
    public val javaValue: com.pulumi.azurenative.synapse.enums.DataFlowComputeType,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.DataFlowComputeType> {
    General(com.pulumi.azurenative.synapse.enums.DataFlowComputeType.General),
    MemoryOptimized(com.pulumi.azurenative.synapse.enums.DataFlowComputeType.MemoryOptimized),
    ComputeOptimized(com.pulumi.azurenative.synapse.enums.DataFlowComputeType.ComputeOptimized),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.DataFlowComputeType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.DataFlowComputeType): DataFlowComputeType = DataFlowComputeType.values().first { it.javaValue == javaType }
    }
}
