@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
 */
public enum class IntegrationRuntimeSsisCatalogPricingTier(
    public val javaValue: com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier> {
    Basic(com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier.Basic),
    Standard(com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier.Standard),
    Premium(com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier.Premium),
    PremiumRS(com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier.PremiumRS),
    ;

    override fun toJava(): com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.enums.IntegrationRuntimeSsisCatalogPricingTier): IntegrationRuntimeSsisCatalogPricingTier =
            IntegrationRuntimeSsisCatalogPricingTier.values().first { it.javaValue == javaType }
    }
}
