@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.AzureSkuArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.SkuName
import com.pulumi.azurenative.synapse.kotlin.enums.SkuSize
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure SKU definition.
 * @property capacity The number of instances of the cluster.
 * @property name SKU name.
 * @property size SKU size.
 */
public data class AzureSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, SkuName>>,
    public val size: Output<Either<String, SkuSize>>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.AzureSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.AzureSkuArgs =
        com.pulumi.azurenative.synapse.inputs.AzureSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .size(
                size.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureSkuArgs].
 */
@PulumiTagMarker
public class AzureSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuName>>? = null

    private var size: Output<Either<String, SkuSize>>? = null

    /**
     * @param value The number of instances of the cluster.
     */
    @JvmName("bpbohyjdcoyxihgh")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value SKU name.
     */
    @JvmName("piriweealjimuyju")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value SKU size.
     */
    @JvmName("uhhyxdfohkhajrjy")
    public suspend fun size(`value`: Output<Either<String, SkuSize>>) {
        this.size = value
    }

    /**
     * @param value The number of instances of the cluster.
     */
    @JvmName("ycmmoqroknbtjpon")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("yducsjudsnnmamyg")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("ixibataxwfumerbv")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU name.
     */
    @JvmName("wcaepxtqennrfpta")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SKU size.
     */
    @JvmName("drvtmgkkqteqixvx")
    public suspend fun size(`value`: Either<String, SkuSize>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value SKU size.
     */
    @JvmName("tiojckwsjjrufntk")
    public fun size(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value SKU size.
     */
    @JvmName("gmhbicgbbilacxvh")
    public fun size(`value`: SkuSize) {
        val toBeMapped = Either.ofRight<String, SkuSize>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): AzureSkuArgs = AzureSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size ?: throw PulumiNullFieldException("size"),
    )
}
