@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.CmdkeySetupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The custom setup of running cmdkey commands.
 * @property password The password of data source access.
 * @property targetName The server name of data source access.
 * @property type The type of custom setup.
 * Expected value is 'CmdkeySetup'.
 * @property userName The user name of data source access.
 */
public data class CmdkeySetupArgs(
    public val password: Output<SecureStringArgs>,
    public val targetName: Output<Any>,
    public val type: Output<String>,
    public val userName: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.CmdkeySetupArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.CmdkeySetupArgs =
        com.pulumi.azurenative.synapse.inputs.CmdkeySetupArgs.builder()
            .password(password.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetName(targetName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userName(userName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CmdkeySetupArgs].
 */
@PulumiTagMarker
public class CmdkeySetupArgsBuilder internal constructor() {
    private var password: Output<SecureStringArgs>? = null

    private var targetName: Output<Any>? = null

    private var type: Output<String>? = null

    private var userName: Output<Any>? = null

    /**
     * @param value The password of data source access.
     */
    @JvmName("bychtmypadwsfvwi")
    public suspend fun password(`value`: Output<SecureStringArgs>) {
        this.password = value
    }

    /**
     * @param value The server name of data source access.
     */
    @JvmName("khogbbrmskomlcpj")
    public suspend fun targetName(`value`: Output<Any>) {
        this.targetName = value
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'CmdkeySetup'.
     */
    @JvmName("idyecithsmevmhgh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user name of data source access.
     */
    @JvmName("ranagtjlujfvgxlr")
    public suspend fun userName(`value`: Output<Any>) {
        this.userName = value
    }

    /**
     * @param value The password of data source access.
     */
    @JvmName("lrhqkhiyedbomvab")
    public suspend fun password(`value`: SecureStringArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The password of data source access.
     */
    @JvmName("quxfehycevneqcvs")
    public suspend fun password(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value The server name of data source access.
     */
    @JvmName("rqjcpvqrluhhqavb")
    public suspend fun targetName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    /**
     * @param value The type of custom setup.
     * Expected value is 'CmdkeySetup'.
     */
    @JvmName("ruifwxxboofrywgo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user name of data source access.
     */
    @JvmName("mtafpqspucjyupvb")
    public suspend fun userName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): CmdkeySetupArgs = CmdkeySetupArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        targetName = targetName ?: throw PulumiNullFieldException("targetName"),
        type = type ?: throw PulumiNullFieldException("type"),
        userName = userName ?: throw PulumiNullFieldException("userName"),
    )
}
