@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.DataLakeStorageAccountDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the data lake storage account associated with the workspace
 * @property accountUrl Account URL
 * @property createManagedPrivateEndpoint Create managed private endpoint to this storage account or not
 * @property filesystem Filesystem name
 * @property resourceId ARM resource Id of this storage account
 */
public data class DataLakeStorageAccountDetailsArgs(
    public val accountUrl: Output<String>? = null,
    public val createManagedPrivateEndpoint: Output<Boolean>? = null,
    public val filesystem: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.DataLakeStorageAccountDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.DataLakeStorageAccountDetailsArgs =
        com.pulumi.azurenative.synapse.inputs.DataLakeStorageAccountDetailsArgs.builder()
            .accountUrl(accountUrl?.applyValue({ args0 -> args0 }))
            .createManagedPrivateEndpoint(createManagedPrivateEndpoint?.applyValue({ args0 -> args0 }))
            .filesystem(filesystem?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeStorageAccountDetailsArgs].
 */
@PulumiTagMarker
public class DataLakeStorageAccountDetailsArgsBuilder internal constructor() {
    private var accountUrl: Output<String>? = null

    private var createManagedPrivateEndpoint: Output<Boolean>? = null

    private var filesystem: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Account URL
     */
    @JvmName("wpqinbitkgmmicmq")
    public suspend fun accountUrl(`value`: Output<String>) {
        this.accountUrl = value
    }

    /**
     * @param value Create managed private endpoint to this storage account or not
     */
    @JvmName("bqgasxxyygkfcxgf")
    public suspend fun createManagedPrivateEndpoint(`value`: Output<Boolean>) {
        this.createManagedPrivateEndpoint = value
    }

    /**
     * @param value Filesystem name
     */
    @JvmName("wpvqyvldugknjxhk")
    public suspend fun filesystem(`value`: Output<String>) {
        this.filesystem = value
    }

    /**
     * @param value ARM resource Id of this storage account
     */
    @JvmName("lbtesottfismrcwt")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Account URL
     */
    @JvmName("ywsadstplxugfain")
    public suspend fun accountUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountUrl = mapped
    }

    /**
     * @param value Create managed private endpoint to this storage account or not
     */
    @JvmName("plrhdsdhveljtqar")
    public suspend fun createManagedPrivateEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createManagedPrivateEndpoint = mapped
    }

    /**
     * @param value Filesystem name
     */
    @JvmName("qsjvwubqvocyqyrp")
    public suspend fun filesystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filesystem = mapped
    }

    /**
     * @param value ARM resource Id of this storage account
     */
    @JvmName("egyckmsuvuorxede")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): DataLakeStorageAccountDetailsArgs = DataLakeStorageAccountDetailsArgs(
        accountUrl = accountUrl,
        createManagedPrivateEndpoint = createManagedPrivateEndpoint,
        filesystem = filesystem,
        resourceId = resourceId,
    )
}
