@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property integrationRuntimeName Integration runtime name
 * @property metadataPath Metadata path.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetIntegrationRuntimeObjectMetadatumPlainArgs(
    public val integrationRuntimeName: String,
    public val metadataPath: String? = null,
    public val resourceGroupName: String,
    public val workspaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs.builder()
            .integrationRuntimeName(integrationRuntimeName.let({ args0 -> args0 }))
            .metadataPath(metadataPath?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationRuntimeObjectMetadatumPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder internal constructor() {
    private var integrationRuntimeName: String? = null

    private var metadataPath: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value Integration runtime name
     */
    @JvmName("gplysturtmuilbyr")
    public suspend fun integrationRuntimeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value Metadata path.
     */
    @JvmName("lmamdltfsapcssak")
    public suspend fun metadataPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metadataPath = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ydbrapfbdisyitiq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("onefwiscnjrfbhna")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetIntegrationRuntimeObjectMetadatumPlainArgs =
        GetIntegrationRuntimeObjectMetadatumPlainArgs(
            integrationRuntimeName = integrationRuntimeName ?: throw
                PulumiNullFieldException("integrationRuntimeName"),
            metadataPath = metadataPath,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
