@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolSensitivityLabelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName The name of the column.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property schemaName The name of the schema.
 * @property sensitivityLabelSource The source of the sensitivity label.
 * @property sqlPoolName SQL pool name
 * @property tableName The name of the table.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolSensitivityLabelPlainArgs(
    public val columnName: String,
    public val resourceGroupName: String,
    public val schemaName: String,
    public val sensitivityLabelSource: String,
    public val sqlPoolName: String,
    public val tableName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolSensitivityLabelPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetSqlPoolSensitivityLabelPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetSqlPoolSensitivityLabelPlainArgs.builder()
            .columnName(columnName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .schemaName(schemaName.let({ args0 -> args0 }))
            .sensitivityLabelSource(sensitivityLabelSource.let({ args0 -> args0 }))
            .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolSensitivityLabelPlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolSensitivityLabelPlainArgsBuilder internal constructor() {
    private var columnName: String? = null

    private var resourceGroupName: String? = null

    private var schemaName: String? = null

    private var sensitivityLabelSource: String? = null

    private var sqlPoolName: String? = null

    private var tableName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the column.
     */
    @JvmName("pldmcmpfsbcqgnpg")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.columnName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odfdjuldksbwrsqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schema.
     */
    @JvmName("sydxcspfvlcpuvkq")
    public suspend fun schemaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.schemaName = mapped
    }

    /**
     * @param value The source of the sensitivity label.
     */
    @JvmName("hbtluiwwjmhnawqc")
    public suspend fun sensitivityLabelSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sensitivityLabelSource = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("ahioqefdlehytayv")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("xrduuuejqatkodln")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("kqfmxddtwhanvjio")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolSensitivityLabelPlainArgs = GetSqlPoolSensitivityLabelPlainArgs(
        columnName = columnName ?: throw PulumiNullFieldException("columnName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        schemaName = schemaName ?: throw PulumiNullFieldException("schemaName"),
        sensitivityLabelSource = sensitivityLabelSource ?: throw
            PulumiNullFieldException("sensitivityLabelSource"),
        sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
