@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadClassifierPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sqlPoolName SQL pool name
 * @property workloadClassifierName The name of the workload classifier.
 * @property workloadGroupName The name of the workload group.
 * @property workspaceName The name of the workspace.
 */
public data class GetSqlPoolWorkloadClassifierPlainArgs(
    public val resourceGroupName: String,
    public val sqlPoolName: String,
    public val workloadClassifierName: String,
    public val workloadGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadClassifierPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadClassifierPlainArgs = com.pulumi.azurenative.synapse.inputs.GetSqlPoolWorkloadClassifierPlainArgs.builder()
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .sqlPoolName(sqlPoolName.let({ args0 -> args0 }))
        .workloadClassifierName(workloadClassifierName.let({ args0 -> args0 }))
        .workloadGroupName(workloadGroupName.let({ args0 -> args0 }))
        .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlPoolWorkloadClassifierPlainArgs].
 */
@PulumiTagMarker
public class GetSqlPoolWorkloadClassifierPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlPoolName: String? = null

    private var workloadClassifierName: String? = null

    private var workloadGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kihyqqcfggkbcjiv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL pool name
     */
    @JvmName("udiipexpqoalpajs")
    public suspend fun sqlPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlPoolName = mapped
    }

    /**
     * @param value The name of the workload classifier.
     */
    @JvmName("rsqqrfhrofsdvggu")
    public suspend fun workloadClassifierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadClassifierName = mapped
    }

    /**
     * @param value The name of the workload group.
     */
    @JvmName("yhwlvuxuscninmqc")
    public suspend fun workloadGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("pmeflwyhwydomrbi")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSqlPoolWorkloadClassifierPlainArgs =
        GetSqlPoolWorkloadClassifierPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            sqlPoolName = sqlPoolName ?: throw PulumiNullFieldException("sqlPoolName"),
            workloadClassifierName = workloadClassifierName ?: throw
                PulumiNullFieldException("workloadClassifierName"),
            workloadGroupName = workloadGroupName ?: throw PulumiNullFieldException("workloadGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
