@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.GetWorkspaceAadAdminPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class GetWorkspaceAadAdminPlainArgs(
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.GetWorkspaceAadAdminPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.GetWorkspaceAadAdminPlainArgs =
        com.pulumi.azurenative.synapse.inputs.GetWorkspaceAadAdminPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspaceAadAdminPlainArgs].
 */
@PulumiTagMarker
public class GetWorkspaceAadAdminPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eikeqgpmgeftmtdv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("imaqmmovrwboydij")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspaceAadAdminPlainArgs = GetWorkspaceAadAdminPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
