@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisCatalogInfoArgs.builder
import com.pulumi.azurenative.synapse.kotlin.enums.IntegrationRuntimeSsisCatalogPricingTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Catalog information for managed dedicated integration runtime.
 * @property catalogAdminPassword The password of the administrator user account of the catalog database.
 * @property catalogAdminUserName The administrator user name of catalog database.
 * @property catalogPricingTier The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
 * @property catalogServerEndpoint The catalog database server URL.
 */
public data class IntegrationRuntimeSsisCatalogInfoArgs(
    public val catalogAdminPassword: Output<SecureStringArgs>? = null,
    public val catalogAdminUserName: Output<String>? = null,
    public val catalogPricingTier: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>? =
        null,
    public val catalogServerEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisCatalogInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisCatalogInfoArgs = com.pulumi.azurenative.synapse.inputs.IntegrationRuntimeSsisCatalogInfoArgs.builder()
        .catalogAdminPassword(
            catalogAdminPassword?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .catalogAdminUserName(catalogAdminUserName?.applyValue({ args0 -> args0 }))
        .catalogPricingTier(
            catalogPricingTier?.applyValue({ args0 ->
                args0.transform(
                    { args0 -> args0 },
                    { args0 -> args0.let({ args0 -> args0.toJava() }) },
                )
            }),
        )
        .catalogServerEndpoint(catalogServerEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeSsisCatalogInfoArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeSsisCatalogInfoArgsBuilder internal constructor() {
    private var catalogAdminPassword: Output<SecureStringArgs>? = null

    private var catalogAdminUserName: Output<String>? = null

    private var catalogPricingTier: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>? =
        null

    private var catalogServerEndpoint: Output<String>? = null

    /**
     * @param value The password of the administrator user account of the catalog database.
     */
    @JvmName("lflhqhootetdemrp")
    public suspend fun catalogAdminPassword(`value`: Output<SecureStringArgs>) {
        this.catalogAdminPassword = value
    }

    /**
     * @param value The administrator user name of catalog database.
     */
    @JvmName("jnkpcohllcnpmecb")
    public suspend fun catalogAdminUserName(`value`: Output<String>) {
        this.catalogAdminUserName = value
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("pxergejcsafwwvyu")
    public suspend fun catalogPricingTier(`value`: Output<Either<String, IntegrationRuntimeSsisCatalogPricingTier>>) {
        this.catalogPricingTier = value
    }

    /**
     * @param value The catalog database server URL.
     */
    @JvmName("qkimbfviogsyiwyw")
    public suspend fun catalogServerEndpoint(`value`: Output<String>) {
        this.catalogServerEndpoint = value
    }

    /**
     * @param value The password of the administrator user account of the catalog database.
     */
    @JvmName("qcelmtntbomembkh")
    public suspend fun catalogAdminPassword(`value`: SecureStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogAdminPassword = mapped
    }

    /**
     * @param argument The password of the administrator user account of the catalog database.
     */
    @JvmName("vbxvuourfmpgylcm")
    public suspend fun catalogAdminPassword(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.catalogAdminPassword = mapped
    }

    /**
     * @param value The administrator user name of catalog database.
     */
    @JvmName("wdkflsjgabrdosnv")
    public suspend fun catalogAdminUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogAdminUserName = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("bhnjekyoiwmlvtcs")
    public suspend fun catalogPricingTier(`value`: Either<String, IntegrationRuntimeSsisCatalogPricingTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("qmdkhvgqhsnijmgg")
    public fun catalogPricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeSsisCatalogPricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
     */
    @JvmName("eyikkdjksxxfbaqo")
    public fun catalogPricingTier(`value`: IntegrationRuntimeSsisCatalogPricingTier) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeSsisCatalogPricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.catalogPricingTier = mapped
    }

    /**
     * @param value The catalog database server URL.
     */
    @JvmName("mwgxutkwctdijfhm")
    public suspend fun catalogServerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogServerEndpoint = mapped
    }

    internal fun build(): IntegrationRuntimeSsisCatalogInfoArgs =
        IntegrationRuntimeSsisCatalogInfoArgs(
            catalogAdminPassword = catalogAdminPassword,
            catalogAdminUserName = catalogAdminUserName,
            catalogPricingTier = catalogPricingTier,
            catalogServerEndpoint = catalogServerEndpoint,
        )
}
