@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The role based access control (RBAC) authorization type integration runtime.
 * @property authorizationType The authorization type for integration runtime sharing.
 * Expected value is 'RBAC'.
 * @property resourceId The resource identifier of the integration runtime to be shared.
 */
public data class LinkedIntegrationRuntimeRbacAuthorizationArgs(
    public val authorizationType: Output<String>,
    public val resourceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs =
        com.pulumi.azurenative.synapse.inputs.LinkedIntegrationRuntimeRbacAuthorizationArgs.builder()
            .authorizationType(authorizationType.applyValue({ args0 -> args0 }))
            .resourceId(resourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedIntegrationRuntimeRbacAuthorizationArgs].
 */
@PulumiTagMarker
public class LinkedIntegrationRuntimeRbacAuthorizationArgsBuilder internal constructor() {
    private var authorizationType: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'RBAC'.
     */
    @JvmName("cccppmaubaqctfyv")
    public suspend fun authorizationType(`value`: Output<String>) {
        this.authorizationType = value
    }

    /**
     * @param value The resource identifier of the integration runtime to be shared.
     */
    @JvmName("gfqlolbfeyjivcbo")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The authorization type for integration runtime sharing.
     * Expected value is 'RBAC'.
     */
    @JvmName("twldpgqbhncctflc")
    public suspend fun authorizationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationType = mapped
    }

    /**
     * @param value The resource identifier of the integration runtime to be shared.
     */
    @JvmName("kaldsgdkmgneqeql")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): LinkedIntegrationRuntimeRbacAuthorizationArgs =
        LinkedIntegrationRuntimeRbacAuthorizationArgs(
            authorizationType = authorizationType ?: throw PulumiNullFieldException("authorizationType"),
            resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
        )
}
