@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.ListKustoPoolFollowerDatabasesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kustoPoolName The name of the Kusto pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the workspace.
 */
public data class ListKustoPoolFollowerDatabasesPlainArgs(
    public val kustoPoolName: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.ListKustoPoolFollowerDatabasesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.ListKustoPoolFollowerDatabasesPlainArgs =
        com.pulumi.azurenative.synapse.inputs.ListKustoPoolFollowerDatabasesPlainArgs.builder()
            .kustoPoolName(kustoPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListKustoPoolFollowerDatabasesPlainArgs].
 */
@PulumiTagMarker
public class ListKustoPoolFollowerDatabasesPlainArgsBuilder internal constructor() {
    private var kustoPoolName: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the Kusto pool.
     */
    @JvmName("alygoqjnmpjhyace")
    public suspend fun kustoPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kustoPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mglnnlolbtadxkov")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("icvgeaefuesatfui")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): ListKustoPoolFollowerDatabasesPlainArgs =
        ListKustoPoolFollowerDatabasesPlainArgs(
            kustoPoolName = kustoPoolName ?: throw PulumiNullFieldException("kustoPoolName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
        )
}
