@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.ManagedIntegrationRuntimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
 * @property computeProperties The compute resource for managed integration runtime.
 * @property customerVirtualNetwork The name of virtual network to which Azure-SSIS integration runtime will join
 * @property description Integration runtime description.
 * @property id The id of the managed virtual network.
 * @property referenceName The reference name of the managed virtual network
 * @property ssisProperties SSIS properties for managed integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'Managed'.
 */
public data class ManagedIntegrationRuntimeArgs(
    public val computeProperties: Output<IntegrationRuntimeComputePropertiesArgs>? = null,
    public val customerVirtualNetwork: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>? = null,
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val referenceName: Output<String>? = null,
    public val ssisProperties: Output<IntegrationRuntimeSsisPropertiesArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.ManagedIntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.ManagedIntegrationRuntimeArgs =
        com.pulumi.azurenative.synapse.inputs.ManagedIntegrationRuntimeArgs.builder()
            .computeProperties(computeProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerVirtualNetwork(
                customerVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .referenceName(referenceName?.applyValue({ args0 -> args0 }))
            .ssisProperties(ssisProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class ManagedIntegrationRuntimeArgsBuilder internal constructor() {
    private var computeProperties: Output<IntegrationRuntimeComputePropertiesArgs>? = null

    private var customerVirtualNetwork: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>? = null

    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var referenceName: Output<String>? = null

    private var ssisProperties: Output<IntegrationRuntimeSsisPropertiesArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The compute resource for managed integration runtime.
     */
    @JvmName("xfcylciywmdjklws")
    public suspend fun computeProperties(`value`: Output<IntegrationRuntimeComputePropertiesArgs>) {
        this.computeProperties = value
    }

    /**
     * @param value The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("bbcchubomjilrjli")
    public suspend fun customerVirtualNetwork(`value`: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>) {
        this.customerVirtualNetwork = value
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("vifusxuhbiltntgc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The id of the managed virtual network.
     */
    @JvmName("acoiceugifrvymwk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The reference name of the managed virtual network
     */
    @JvmName("psiurcukscaksenf")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value SSIS properties for managed integration runtime.
     */
    @JvmName("lvcnbkunyutlhuwq")
    public suspend fun ssisProperties(`value`: Output<IntegrationRuntimeSsisPropertiesArgs>) {
        this.ssisProperties = value
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'Managed'.
     */
    @JvmName("kwonhrcplaaaepss")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The compute resource for managed integration runtime.
     */
    @JvmName("eoccsqbdmjhphcpa")
    public suspend fun computeProperties(`value`: IntegrationRuntimeComputePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProperties = mapped
    }

    /**
     * @param argument The compute resource for managed integration runtime.
     */
    @JvmName("fdxccawlnlsquprt")
    public suspend fun computeProperties(argument: suspend IntegrationRuntimeComputePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeComputePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.computeProperties = mapped
    }

    /**
     * @param value The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("bpmqfkpylqbjkakb")
    public suspend fun customerVirtualNetwork(`value`: IntegrationRuntimeCustomerVirtualNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerVirtualNetwork = mapped
    }

    /**
     * @param argument The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("pcletdetvwujydxy")
    public suspend fun customerVirtualNetwork(argument: suspend IntegrationRuntimeCustomerVirtualNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeCustomerVirtualNetworkArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customerVirtualNetwork = mapped
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("sedpnprksjduxudt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The id of the managed virtual network.
     */
    @JvmName("jewtvmdlriyqrasq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The reference name of the managed virtual network
     */
    @JvmName("rlssikdpkurmjetp")
    public suspend fun referenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value SSIS properties for managed integration runtime.
     */
    @JvmName("aobpqwnlacquhuqv")
    public suspend fun ssisProperties(`value`: IntegrationRuntimeSsisPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssisProperties = mapped
    }

    /**
     * @param argument SSIS properties for managed integration runtime.
     */
    @JvmName("saraqpipivpkymlx")
    public suspend fun ssisProperties(argument: suspend IntegrationRuntimeSsisPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeSsisPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ssisProperties = mapped
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'Managed'.
     */
    @JvmName("ufraklgdvouhqbfb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedIntegrationRuntimeArgs = ManagedIntegrationRuntimeArgs(
        computeProperties = computeProperties,
        customerVirtualNetwork = customerVirtualNetwork,
        description = description,
        id = id,
        referenceName = referenceName,
        ssisProperties = ssisProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
