@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties for an Sql pool vulnerability assessment rule baseline's result.
 * @property result The rule baseline result
 */
public data class SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs(
    public val result: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs =
        com.pulumi.azurenative.synapse.inputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs.builder()
            .result(result.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs].
 */
@PulumiTagMarker
public class SqlPoolVulnerabilityAssessmentRuleBaselineItemArgsBuilder internal constructor() {
    private var result: Output<List<String>>? = null

    /**
     * @param value The rule baseline result
     */
    @JvmName("ijjyebsgnaleylre")
    public suspend fun result(`value`: Output<List<String>>) {
        this.result = value
    }

    @JvmName("sxojnpdwaxyehrya")
    public suspend fun result(vararg values: Output<String>) {
        this.result = Output.all(values.asList())
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("uiejtvxmjsaxgokq")
    public suspend fun result(values: List<Output<String>>) {
        this.result = Output.all(values)
    }

    /**
     * @param value The rule baseline result
     */
    @JvmName("lveaqwurhikkqdoj")
    public suspend fun result(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.result = mapped
    }

    /**
     * @param values The rule baseline result
     */
    @JvmName("emhgykovsghpokag")
    public suspend fun result(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.result = mapped
    }

    internal fun build(): SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs =
        SqlPoolVulnerabilityAssessmentRuleBaselineItemArgs(
            result = result ?: throw PulumiNullFieldException("result"),
        )
}
