@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.TableLevelSharingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Tables that will be included and excluded in the follower database
 * @property externalTablesToExclude List of external tables exclude from the follower database
 * @property externalTablesToInclude List of external tables to include in the follower database
 * @property materializedViewsToExclude List of materialized views exclude from the follower database
 * @property materializedViewsToInclude List of materialized views to include in the follower database
 * @property tablesToExclude List of tables to exclude from the follower database
 * @property tablesToInclude List of tables to include in the follower database
 */
public data class TableLevelSharingPropertiesArgs(
    public val externalTablesToExclude: Output<List<String>>? = null,
    public val externalTablesToInclude: Output<List<String>>? = null,
    public val materializedViewsToExclude: Output<List<String>>? = null,
    public val materializedViewsToInclude: Output<List<String>>? = null,
    public val tablesToExclude: Output<List<String>>? = null,
    public val tablesToInclude: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.TableLevelSharingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.TableLevelSharingPropertiesArgs =
        com.pulumi.azurenative.synapse.inputs.TableLevelSharingPropertiesArgs.builder()
            .externalTablesToExclude(
                externalTablesToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .externalTablesToInclude(
                externalTablesToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToExclude(
                materializedViewsToExclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .materializedViewsToInclude(
                materializedViewsToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tablesToExclude(tablesToExclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tablesToInclude(tablesToInclude?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [TableLevelSharingPropertiesArgs].
 */
@PulumiTagMarker
public class TableLevelSharingPropertiesArgsBuilder internal constructor() {
    private var externalTablesToExclude: Output<List<String>>? = null

    private var externalTablesToInclude: Output<List<String>>? = null

    private var materializedViewsToExclude: Output<List<String>>? = null

    private var materializedViewsToInclude: Output<List<String>>? = null

    private var tablesToExclude: Output<List<String>>? = null

    private var tablesToInclude: Output<List<String>>? = null

    /**
     * @param value List of external tables exclude from the follower database
     */
    @JvmName("ytfwbsvqeqyitfxn")
    public suspend fun externalTablesToExclude(`value`: Output<List<String>>) {
        this.externalTablesToExclude = value
    }

    @JvmName("enemevdxgvbxmreo")
    public suspend fun externalTablesToExclude(vararg values: Output<String>) {
        this.externalTablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables exclude from the follower database
     */
    @JvmName("iuvkxtujdnfvormw")
    public suspend fun externalTablesToExclude(values: List<Output<String>>) {
        this.externalTablesToExclude = Output.all(values)
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("hihmyuompckpntxn")
    public suspend fun externalTablesToInclude(`value`: Output<List<String>>) {
        this.externalTablesToInclude = value
    }

    @JvmName("tbaswmfcrknijhtq")
    public suspend fun externalTablesToInclude(vararg values: Output<String>) {
        this.externalTablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("xeymmvhmyvdgvfao")
    public suspend fun externalTablesToInclude(values: List<Output<String>>) {
        this.externalTablesToInclude = Output.all(values)
    }

    /**
     * @param value List of materialized views exclude from the follower database
     */
    @JvmName("nwhhdvlbpbvwcasv")
    public suspend fun materializedViewsToExclude(`value`: Output<List<String>>) {
        this.materializedViewsToExclude = value
    }

    @JvmName("tbpaimwircbgkrwk")
    public suspend fun materializedViewsToExclude(vararg values: Output<String>) {
        this.materializedViewsToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views exclude from the follower database
     */
    @JvmName("iwkpkislvomktkak")
    public suspend fun materializedViewsToExclude(values: List<Output<String>>) {
        this.materializedViewsToExclude = Output.all(values)
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("qmxhiscouukvfkkv")
    public suspend fun materializedViewsToInclude(`value`: Output<List<String>>) {
        this.materializedViewsToInclude = value
    }

    @JvmName("pynrsyrmksfcnldu")
    public suspend fun materializedViewsToInclude(vararg values: Output<String>) {
        this.materializedViewsToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("bprddttxksojxafu")
    public suspend fun materializedViewsToInclude(values: List<Output<String>>) {
        this.materializedViewsToInclude = Output.all(values)
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("bprmcygtynqntvbt")
    public suspend fun tablesToExclude(`value`: Output<List<String>>) {
        this.tablesToExclude = value
    }

    @JvmName("gtdxfjyvnhfvyrtk")
    public suspend fun tablesToExclude(vararg values: Output<String>) {
        this.tablesToExclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("bjuotykskbpgurkw")
    public suspend fun tablesToExclude(values: List<Output<String>>) {
        this.tablesToExclude = Output.all(values)
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("lasylnpdgekjgybo")
    public suspend fun tablesToInclude(`value`: Output<List<String>>) {
        this.tablesToInclude = value
    }

    @JvmName("owddnchcnanmtmea")
    public suspend fun tablesToInclude(vararg values: Output<String>) {
        this.tablesToInclude = Output.all(values.asList())
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("mcpbemergxxbewpi")
    public suspend fun tablesToInclude(values: List<Output<String>>) {
        this.tablesToInclude = Output.all(values)
    }

    /**
     * @param value List of external tables exclude from the follower database
     */
    @JvmName("yqrjleetbesmvjht")
    public suspend fun externalTablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param values List of external tables exclude from the follower database
     */
    @JvmName("ptvpmdpbnvhuimbi")
    public suspend fun externalTablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToExclude = mapped
    }

    /**
     * @param value List of external tables to include in the follower database
     */
    @JvmName("cplwccxxiiegkwbi")
    public suspend fun externalTablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param values List of external tables to include in the follower database
     */
    @JvmName("jbwxkqerurfflxhs")
    public suspend fun externalTablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalTablesToInclude = mapped
    }

    /**
     * @param value List of materialized views exclude from the follower database
     */
    @JvmName("fcoqcwhvvuvqnliv")
    public suspend fun materializedViewsToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param values List of materialized views exclude from the follower database
     */
    @JvmName("sxewcmbaqvdjiwjx")
    public suspend fun materializedViewsToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToExclude = mapped
    }

    /**
     * @param value List of materialized views to include in the follower database
     */
    @JvmName("ucgskdqckhuwtbxg")
    public suspend fun materializedViewsToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param values List of materialized views to include in the follower database
     */
    @JvmName("xvvinorihnthoikq")
    public suspend fun materializedViewsToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.materializedViewsToInclude = mapped
    }

    /**
     * @param value List of tables to exclude from the follower database
     */
    @JvmName("sfcuuipviaflyvln")
    public suspend fun tablesToExclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param values List of tables to exclude from the follower database
     */
    @JvmName("kqqvuacdmxtpxnaf")
    public suspend fun tablesToExclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToExclude = mapped
    }

    /**
     * @param value List of tables to include in the follower database
     */
    @JvmName("xpufvsctovsxmuxy")
    public suspend fun tablesToInclude(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    /**
     * @param values List of tables to include in the follower database
     */
    @JvmName("oiehiwodlfotrbvk")
    public suspend fun tablesToInclude(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablesToInclude = mapped
    }

    internal fun build(): TableLevelSharingPropertiesArgs = TableLevelSharingPropertiesArgs(
        externalTablesToExclude = externalTablesToExclude,
        externalTablesToInclude = externalTablesToInclude,
        materializedViewsToExclude = materializedViewsToExclude,
        materializedViewsToInclude = materializedViewsToInclude,
        tablesToExclude = tablesToExclude,
        tablesToInclude = tablesToInclude,
    )
}
