@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.inputs

import com.pulumi.azurenative.synapse.inputs.WorkspaceRepositoryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Git integration settings
 * @property accountName Account name
 * @property collaborationBranch Collaboration branch
 * @property hostName GitHub Enterprise host name. For example: `https://github.mydomain.com`
 * @property lastCommitId The last commit ID
 * @property projectName VSTS project name
 * @property repositoryName Repository name
 * @property rootFolder Root folder to use in the repository
 * @property tenantId The VSTS tenant ID
 * @property type Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
 */
public data class WorkspaceRepositoryConfigurationArgs(
    public val accountName: Output<String>? = null,
    public val collaborationBranch: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val lastCommitId: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val repositoryName: Output<String>? = null,
    public val rootFolder: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.synapse.inputs.WorkspaceRepositoryConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.synapse.inputs.WorkspaceRepositoryConfigurationArgs = com.pulumi.azurenative.synapse.inputs.WorkspaceRepositoryConfigurationArgs.builder()
        .accountName(accountName?.applyValue({ args0 -> args0 }))
        .collaborationBranch(collaborationBranch?.applyValue({ args0 -> args0 }))
        .hostName(hostName?.applyValue({ args0 -> args0 }))
        .lastCommitId(lastCommitId?.applyValue({ args0 -> args0 }))
        .projectName(projectName?.applyValue({ args0 -> args0 }))
        .repositoryName(repositoryName?.applyValue({ args0 -> args0 }))
        .rootFolder(rootFolder?.applyValue({ args0 -> args0 }))
        .tenantId(tenantId?.applyValue({ args0 -> args0 }))
        .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceRepositoryConfigurationArgs].
 */
@PulumiTagMarker
public class WorkspaceRepositoryConfigurationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var collaborationBranch: Output<String>? = null

    private var hostName: Output<String>? = null

    private var lastCommitId: Output<String>? = null

    private var projectName: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var rootFolder: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Account name
     */
    @JvmName("ohahiswulullytpq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Collaboration branch
     */
    @JvmName("qjnjserxgsfvtsim")
    public suspend fun collaborationBranch(`value`: Output<String>) {
        this.collaborationBranch = value
    }

    /**
     * @param value GitHub Enterprise host name. For example: `https://github.mydomain.com`
     */
    @JvmName("shxjbkvglwooolag")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The last commit ID
     */
    @JvmName("eftimdfybjcdpnvq")
    public suspend fun lastCommitId(`value`: Output<String>) {
        this.lastCommitId = value
    }

    /**
     * @param value VSTS project name
     */
    @JvmName("adrlyiqukvgxsmgx")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Repository name
     */
    @JvmName("vhrgbvfdcnplqcxr")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Root folder to use in the repository
     */
    @JvmName("wktlxpopnholcese")
    public suspend fun rootFolder(`value`: Output<String>) {
        this.rootFolder = value
    }

    /**
     * @param value The VSTS tenant ID
     */
    @JvmName("qnwhdouycadfjcgm")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
     */
    @JvmName("ngfhehtacpcameov")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Account name
     */
    @JvmName("mxeeupluohvedokv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Collaboration branch
     */
    @JvmName("vmtuqjdauepmsitk")
    public suspend fun collaborationBranch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collaborationBranch = mapped
    }

    /**
     * @param value GitHub Enterprise host name. For example: `https://github.mydomain.com`
     */
    @JvmName("iphmntfxwjxhmoho")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The last commit ID
     */
    @JvmName("drvnswwumvkkvscd")
    public suspend fun lastCommitId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastCommitId = mapped
    }

    /**
     * @param value VSTS project name
     */
    @JvmName("aeegebcotprpxbyf")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Repository name
     */
    @JvmName("qxrphsrbxgljrbav")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Root folder to use in the repository
     */
    @JvmName("efesonrubwbgngpa")
    public suspend fun rootFolder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootFolder = mapped
    }

    /**
     * @param value The VSTS tenant ID
     */
    @JvmName("orlkfxuotsfcpjwi")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration, WorkspaceGitHubConfiguration
     */
    @JvmName("jfubgscyupdtluna")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkspaceRepositoryConfigurationArgs = WorkspaceRepositoryConfigurationArgs(
        accountName = accountName,
        collaborationBranch = collaborationBranch,
        hostName = hostName,
        lastCommitId = lastCommitId,
        projectName = projectName,
        repositoryName = repositoryName,
        rootFolder = rootFolder,
        tenantId = tenantId,
        type = type,
    )
}
