@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Auto-pausing properties of a Big Data pool powered by Apache Spark
 * @property delayInMinutes Number of minutes of idle time before the Big Data pool is automatically paused.
 * @property enabled Whether auto-pausing is enabled for the Big Data pool.
 */
public data class AutoPausePropertiesResponse(
    public val delayInMinutes: Int? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.AutoPausePropertiesResponse): AutoPausePropertiesResponse = AutoPausePropertiesResponse(
            delayInMinutes = javaType.delayInMinutes().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
