@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The custom setup of running cmdkey commands.
 * @property password The password of data source access.
 * @property targetName The server name of data source access.
 * @property type The type of custom setup.
 * Expected value is 'CmdkeySetup'.
 * @property userName The user name of data source access.
 */
public data class CmdkeySetupResponse(
    public val password: SecureStringResponse,
    public val targetName: Any,
    public val type: String,
    public val userName: Any,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.CmdkeySetupResponse): CmdkeySetupResponse = CmdkeySetupResponse(
            password = javaType.password().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SecureStringResponse.Companion.toKotlin(args0)
            }),
            targetName = javaType.targetName(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
