@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Details of the data lake storage account associated with the workspace
 * @property accountUrl Account URL
 * @property createManagedPrivateEndpoint Create managed private endpoint to this storage account or not
 * @property filesystem Filesystem name
 * @property resourceId ARM resource Id of this storage account
 */
public data class DataLakeStorageAccountDetailsResponse(
    public val accountUrl: String? = null,
    public val createManagedPrivateEndpoint: Boolean? = null,
    public val filesystem: String? = null,
    public val resourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.DataLakeStorageAccountDetailsResponse): DataLakeStorageAccountDetailsResponse = DataLakeStorageAccountDetailsResponse(
            accountUrl = javaType.accountUrl().map({ args0 -> args0 }).orElse(null),
            createManagedPrivateEndpoint = javaType.createManagedPrivateEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            filesystem = javaType.filesystem().map({ args0 -> args0 }).orElse(null),
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
