@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Details of the encryption associated with the workspace
 * @property cmk Customer Managed Key Details
 * @property doubleEncryptionEnabled Double Encryption enabled
 */
public data class EncryptionDetailsResponse(
    public val cmk: CustomerManagedKeyDetailsResponse? = null,
    public val doubleEncryptionEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.EncryptionDetailsResponse): EncryptionDetailsResponse = EncryptionDetailsResponse(
            cmk = javaType.cmk().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.synapse.kotlin.outputs.CustomerManagedKeyDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            doubleEncryptionEnabled = javaType.doubleEncryptionEnabled(),
        )
    }
}
