@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing follower database request.
 * @property attachedDatabaseConfigurationName Resource name of the attached database configuration in the follower cluster.
 * @property databaseName The database name owned by this cluster that was followed. * in case following all databases.
 * @property kustoPoolResourceId Resource id of the cluster that follows a database owned by this cluster.
 */
public data class FollowerDatabaseDefinitionResponse(
    public val attachedDatabaseConfigurationName: String,
    public val databaseName: String,
    public val kustoPoolResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.FollowerDatabaseDefinitionResponse): FollowerDatabaseDefinitionResponse = FollowerDatabaseDefinitionResponse(
            attachedDatabaseConfigurationName = javaType.attachedDatabaseConfigurationName(),
            databaseName = javaType.databaseName(),
            kustoPoolResourceId = javaType.kustoPoolResourceId(),
        )
    }
}
