@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.synapse.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing a database principal assignment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property principalId The principal ID assigned to the database principal. It can be a user email, application ID, or security group name.
 * @property principalName The principal name
 * @property principalType Principal type.
 * @property provisioningState The provisioned state of the resource.
 * @property role Database principal role.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tenantId The tenant id of the principal
 * @property tenantName The tenant name of the principal
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDatabasePrincipalAssignmentResult(
    public val id: String,
    public val name: String,
    public val principalId: String,
    public val principalName: String,
    public val principalType: String,
    public val provisioningState: String,
    public val role: String,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val tenantName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.synapse.outputs.GetDatabasePrincipalAssignmentResult): GetDatabasePrincipalAssignmentResult = GetDatabasePrincipalAssignmentResult(
            id = javaType.id(),
            name = javaType.name(),
            principalId = javaType.principalId(),
            principalName = javaType.principalName(),
            principalType = javaType.principalType(),
            provisioningState = javaType.provisioningState(),
            role = javaType.role(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.synapse.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            tenantName = javaType.tenantName(),
            type = javaType.type(),
        )
    }
}
